/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import net.sourceforge.pmd.cpd.AnyCpdLexer;
import net.sourceforge.pmd.cpd.CpdCapableLanguage;
import net.sourceforge.pmd.cpd.CpdLexer;
import net.sourceforge.pmd.lang.LanguageModuleBase;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.ast.AstInfo;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.ast.impl.AbstractNode;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.lang.impl.SimpleLanguageModuleBase;

public final class PlainTextLanguage
extends SimpleLanguageModuleBase
implements CpdCapableLanguage {
    private static final String ID = "text";
    private static final PlainTextLanguage INSTANCE = new PlainTextLanguage();

    private PlainTextLanguage() {
        super(LanguageModuleBase.LanguageMetadata.withId(ID).name("Plain text").extensions("plain-text-file-goo-extension", new String[0]).addDefaultVersion("default", new String[0]), new TextLvh());
    }

    public static PlainTextLanguage getInstance() {
        return INSTANCE;
    }

    @Override
    public CpdLexer createCpdLexer(LanguagePropertyBundle bundle) {
        return new AnyCpdLexer();
    }

    private static final class TextLvh
    implements LanguageVersionHandler {
        private TextLvh() {
        }

        @Override
        public Parser getParser() {
            return PlainTextFile::new;
        }
    }

    public static class PlainTextFile
    extends AbstractNode<PlainTextFile, PlainTextFile>
    implements RootNode {
        private final AstInfo<PlainTextFile> astInfo;

        PlainTextFile(Parser.ParserTask task) {
            this.astInfo = new AstInfo<PlainTextFile>(task, this);
        }

        @Override
        public TextRegion getTextRegion() {
            return this.getTextDocument().getEntireRegion();
        }

        @Override
        public String getXPathNodeName() {
            return "TextFile";
        }

        @Override
        public String getImage() {
            return null;
        }

        @Override
        public String toString() {
            return "Plain text file (" + this.getEndLine() + " lines)";
        }

        @Override
        public AstInfo<? extends RootNode> getAstInfo() {
            return this.astInfo;
        }
    }
}

