/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sarif;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.BiFunction;

class MessageFormat {
    private final String pattern;

    MessageFormat(@NonNull String pattern) {
        this.pattern = Objects.requireNonNull(pattern);
    }

    String format(@NonNull BiFunction<Integer, String, String> handler) {
        Objects.requireNonNull(handler);
        String pat = this.pattern;
        StringBuilder result = new StringBuilder();
        while (!pat.isEmpty()) {
            int fieldNum;
            int subst = pat.indexOf(123);
            if (subst < 0) {
                result.append(pat);
                break;
            }
            result.append(pat.substring(0, subst));
            pat = pat.substring(subst + 1);
            int end = pat.indexOf(125);
            if (end < 0) {
                throw new IllegalStateException("unmatched { in " + pat);
            }
            String substPat = pat.substring(0, end);
            int dot = substPat.indexOf(46);
            String key = "";
            if (dot >= 0) {
                key = substPat.substring(dot + 1);
                substPat = substPat.substring(0, dot);
            }
            try {
                fieldNum = Integer.parseInt(substPat);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bad integer value " + substPat + " in " + this.pattern);
            }
            if (fieldNum < 0) {
                throw new IllegalArgumentException("The given fieldNum was negative: " + fieldNum);
            }
            try {
                result.append(handler.apply(fieldNum, key));
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Problem processing " + this.pattern + " format " + substPat, iae);
            }
            pat = pat.substring(end + 1);
        }
        return result.toString();
    }
}

