/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.log.IProfiler;
import edu.umd.cs.findbugs.log.Profiler;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileSummary
implements IProfiler,
XMLWriteable {
    private static final Logger LOG = LoggerFactory.getLogger(ProfileSummary.class);
    private final Profiler[] profilers;

    public ProfileSummary(Profiler ... profilers) {
        this.profilers = Objects.requireNonNull(profilers);
    }

    public void report(Comparator<Class<?>> reportComparator, Predicate<Profiler.Profile> filter, PrintStream stream) {
        stream.println("PROFILE REPORT");
        try {
            TreeSet treeSet = Arrays.stream(this.profilers).map(Profiler::getTargetClasses).flatMap(Collection::stream).collect(Collectors.toCollection(() -> new TreeSet(reportComparator)));
            stream.printf("%8s  %8s %9s %s%n", "msecs", "#calls", "usecs/call", "Class");
            for (Class c : treeSet) {
                Profiler.Profile p = this.getProfile(c);
                if (!filter.test(p)) continue;
                long time = p.totalTime.get();
                int callCount = p.totalCalls.get();
                stream.printf("%8d  %8d  %8d %s%n", TimeUnit.MILLISECONDS.convert(time, TimeUnit.NANOSECONDS), callCount, TimeUnit.MICROSECONDS.convert(time / (long)callCount, TimeUnit.NANOSECONDS), c.getSimpleName());
            }
            stream.flush();
        }
        catch (RuntimeException e) {
            LOG.error("Failed to print profile report.", (Throwable)e);
        }
    }

    @Override
    public void writeXML(@NonNull XMLOutput xmlOutput) throws IOException {
        xmlOutput.startTag("FindBugsProfile");
        xmlOutput.stopTag(false);
        Profiler.TotalTimeComparator reportComparator = new Profiler.TotalTimeComparator(this);
        TreeSet treeSet = Arrays.stream(this.profilers).map(Profiler::getTargetClasses).flatMap(Collection::stream).collect(Collectors.toCollection(() -> new TreeSet(reportComparator)));
        long totalTime = Arrays.stream(this.profilers).map(Profiler::getProfiles).flatMap(Collection::stream).mapToLong(Profiler.Profile::getTotalTime).sum();
        long accumulatedTime = 0L;
        for (Class c : treeSet) {
            Profiler.Profile p = this.getProfile(c);
            p.writeXML(xmlOutput);
            if ((accumulatedTime += p.getTotalTime()) <= 3L * totalTime / 4L) continue;
            break;
        }
        xmlOutput.closeTag("FindBugsProfile");
    }

    @Override
    public Profiler.Profile getProfile(Class<?> clazz) {
        return Arrays.stream(this.profilers).filter(profiler -> profiler.contains(clazz)).map(profiler -> profiler.getProfile(clazz)).findFirst().orElseThrow(() -> new IllegalArgumentException("Specified class " + String.valueOf(clazz) + " is not analyzed"));
    }
}

