/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.PackageMemberAnnotation;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.NameMatch;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationMatcher
implements Matcher {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationMatcher.class);
    private final NameMatch annotationName;

    public String toString() {
        return "Annotation(name=\"" + this.annotationName.getValue() + "\")";
    }

    public AnnotationMatcher(String annotationName) {
        this.annotationName = new NameMatch(annotationName);
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        for (BugAnnotation bugAnnotation : bugInstance.getAnnotations()) {
            if (!(bugAnnotation instanceof PackageMemberAnnotation)) continue;
            PackageMemberAnnotation pma = (PackageMemberAnnotation)bugAnnotation;
            for (String javaAnnotationName : pma.getJavaAnnotationNames()) {
                if (!this.annotationName.match(javaAnnotationName)) continue;
                LOG.debug("Matched {} in {} with {}", new Object[]{javaAnnotationName, pma.getClassName(), this.annotationName});
                return true;
            }
        }
        return false;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        XMLAttributeList attributes = new XMLAttributeList().addAttribute("name", this.annotationName.getSpec());
        if (disabled) {
            attributes.addAttribute("disabled", "true");
        }
        xmlOutput.openCloseTag("Annotation", attributes);
    }
}

