/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

public class XMLFactoryBypass
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    @StaticConstant
    private static final Set<String> xmlInterfaces = Set.of("javax.xml.parsers.DocumentBuilder", "org.w3c.dom.Document", "javax.xml.parsers.SAXParser", "org.xml.sax.XMLReader", "org.xml.sax.XMLFilter", "javax.xml.transform.Transformer", "org.w3c.dom.Attr", "org.w3c.dom.CDATASection", "org.w3c.dom.Comment", "org.w3c.dom.Element", "org.w3c.dom.Text");
    private final Set<String> rejectedXMLClasses = new HashSet<String>();
    private JavaClass curClass;

    public XMLFactoryBypass(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        this.curClass = classContext.getJavaClass();
        super.visitClassContext(classContext);
    }

    @Override
    public void sawOpcode(int seen) {
        try {
            if (seen == 183) {
                JavaClass[] infs;
                String newClsName = this.getClassConstantOperand();
                if (this.rejectedXMLClasses.contains(newClsName)) {
                    return;
                }
                this.rejectedXMLClasses.add(newClsName);
                if (newClsName.startsWith("java/") || newClsName.startsWith("javax/")) {
                    return;
                }
                if (newClsName.endsWith("Adapter")) {
                    return;
                }
                if (!"<init>".equals(this.getNameConstantOperand())) {
                    return;
                }
                String invokerClsName = this.getClassName();
                if (this.samePackageBase(invokerClsName, newClsName)) {
                    return;
                }
                JavaClass newCls = Repository.lookupClass((String)this.getDottedClassConstantOperand());
                JavaClass superCls = this.curClass.getSuperClass();
                if (superCls.getClassName().equals(ClassName.toDottedClassName(newClsName))) {
                    return;
                }
                for (JavaClass inf : infs = newCls.getAllInterfaces()) {
                    if (!xmlInterfaces.contains(inf.getClassName())) continue;
                    this.bugReporter.reportBug(new BugInstance(this, "XFB_XML_FACTORY_BYPASS", 3).addClassAndMethod(this).addSourceLine(this));
                    this.rejectedXMLClasses.remove(newClsName);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public boolean samePackageBase(String invokerClsName, String newClsName) {
        String[] invokerParts = invokerClsName.split("/");
        String[] newClsParts = newClsName.split("/");
        if (newClsParts.length < 3) {
            return false;
        }
        if (invokerParts.length < 3) {
            return false;
        }
        if (!invokerParts[0].equals(newClsParts[0])) {
            return false;
        }
        return invokerParts[1].equals(newClsParts[1]);
    }
}

