/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ResourceCollection;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.ResourceTracker;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import edu.umd.cs.findbugs.ba.ResourceValueFrameModelingVisitor;
import edu.umd.cs.findbugs.detect.FindOpenStream;
import edu.umd.cs.findbugs.detect.Stream;
import edu.umd.cs.findbugs.detect.StreamEquivalenceClass;
import edu.umd.cs.findbugs.detect.StreamEscape;
import edu.umd.cs.findbugs.detect.StreamFactory;
import edu.umd.cs.findbugs.detect.StreamFrameModelingVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;

public class StreamResourceTracker
implements ResourceTracker<Stream> {
    private final StreamFactory[] streamFactoryList;
    private final RepositoryLookupFailureCallback lookupFailureCallback;
    private ResourceCollection<Stream> resourceCollection;
    private final Map<Location, Stream> streamOpenLocationMap;
    private final HashSet<Stream> uninterestingStreamEscapeSet;
    private final TreeSet<StreamEscape> streamEscapeSet;
    private final Map<Stream, StreamEquivalenceClass> streamEquivalenceMap;

    public StreamResourceTracker(StreamFactory[] streamFactoryList, RepositoryLookupFailureCallback lookupFailureCallback) {
        this.streamFactoryList = streamFactoryList;
        this.lookupFailureCallback = lookupFailureCallback;
        this.streamOpenLocationMap = new HashMap<Location, Stream>();
        this.uninterestingStreamEscapeSet = new HashSet();
        this.streamEscapeSet = new TreeSet();
        this.streamEquivalenceMap = new HashMap<Stream, StreamEquivalenceClass>();
    }

    public void setResourceCollection(ResourceCollection<Stream> resourceCollection) {
        this.resourceCollection = resourceCollection;
    }

    public void addStreamEscape(Stream source, Location target) {
        StreamEscape streamEscape = new StreamEscape(source, target);
        this.streamEscapeSet.add(streamEscape);
        if (FindOpenStream.DEBUG) {
            System.out.println("Adding potential stream escape " + String.valueOf(streamEscape));
        }
    }

    public void markTransitiveUninterestingStreamEscapes() {
        Iterator<Comparable<StreamEscape>> i = this.streamEscapeSet.iterator();
        while (i.hasNext()) {
            StreamEscape streamEscape = i.next();
            if (this.isStreamOpenLocation(streamEscape.target)) continue;
            if (FindOpenStream.DEBUG) {
                System.out.println("Eliminating false stream escape " + String.valueOf(streamEscape));
            }
            i.remove();
        }
        i = this.resourceCollection.resourceIterator();
        while (i.hasNext()) {
            Stream stream = (Stream)i.next();
            StreamEquivalenceClass equivalenceClass = new StreamEquivalenceClass();
            equivalenceClass.addMember(stream);
            this.streamEquivalenceMap.put(stream, equivalenceClass);
        }
        HashSet<Stream> orig = new HashSet<Stream>();
        do {
            orig.clear();
            orig.addAll(this.uninterestingStreamEscapeSet);
            for (StreamEscape streamEscape : this.streamEscapeSet) {
                StreamEquivalenceClass targetClass;
                Stream target;
                if (!this.isUninterestingStreamEscape(streamEscape.source)) continue;
                if (FindOpenStream.DEBUG) {
                    System.out.println("Propagating stream escape " + String.valueOf(streamEscape));
                }
                if ((target = this.streamOpenLocationMap.get(streamEscape.target)) == null) {
                    throw new IllegalStateException();
                }
                this.uninterestingStreamEscapeSet.add(target);
                StreamEquivalenceClass sourceClass = this.streamEquivalenceMap.get(streamEscape.source);
                if (sourceClass == (targetClass = this.streamEquivalenceMap.get(target))) continue;
                sourceClass.addAll(targetClass);
                Iterator<Stream> j = targetClass.memberIterator();
                while (j.hasNext()) {
                    Stream stream = j.next();
                    this.streamEquivalenceMap.put(stream, sourceClass);
                }
            }
        } while (!orig.equals(this.uninterestingStreamEscapeSet));
    }

    public boolean isUninterestingStreamEscape(Stream stream) {
        return this.uninterestingStreamEscapeSet.contains(stream);
    }

    public void addStreamOpenLocation(Location streamOpenLocation, Stream stream) {
        if (FindOpenStream.DEBUG) {
            System.out.println("Stream open location at " + String.valueOf(streamOpenLocation));
        }
        this.streamOpenLocationMap.put(streamOpenLocation, stream);
        if (stream.isUninteresting()) {
            this.uninterestingStreamEscapeSet.add(stream);
        }
    }

    public StreamEquivalenceClass getStreamEquivalenceClass(Stream stream) {
        return this.streamEquivalenceMap.get(stream);
    }

    private boolean isStreamOpenLocation(Location location) {
        return this.streamOpenLocationMap.get(location) != null;
    }

    @Override
    public Stream isResourceCreation(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg) {
        if (this.resourceCollection != null) {
            return this.resourceCollection.getCreatedResource(new Location(handle, basicBlock));
        }
        Instruction ins = handle.getInstruction();
        if (!(ins instanceof TypedInstruction)) {
            return null;
        }
        Type type = ((TypedInstruction)ins).getType(cpg);
        if (!(type instanceof ObjectType)) {
            return null;
        }
        Location location = new Location(handle, basicBlock);
        for (StreamFactory aStreamFactoryList : this.streamFactoryList) {
            Stream stream = aStreamFactoryList.createStream(location, (ObjectType)type, cpg, this.lookupFailureCallback);
            if (stream == null) continue;
            return stream;
        }
        return null;
    }

    public boolean isResourceOpen(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg, Stream resource, ResourceValueFrame frame) {
        return resource.isStreamOpen(basicBlock, handle, cpg, frame);
    }

    @Override
    public boolean isResourceClose(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg, Stream resource, ResourceValueFrame frame) {
        return resource.isStreamClose(basicBlock, handle, cpg, frame, this.lookupFailureCallback);
    }

    @Override
    public boolean mightCloseResource(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg) throws DataflowAnalysisException {
        return Stream.mightCloseStream(basicBlock, handle, cpg);
    }

    @Override
    public ResourceValueFrameModelingVisitor createVisitor(Stream resource, ConstantPoolGen cpg) {
        return new StreamFrameModelingVisitor(cpg, this, resource);
    }

    @Override
    public boolean ignoreImplicitExceptions(Stream resource) {
        return resource.ignoreImplicitExceptions();
    }

    @Override
    public boolean ignoreExceptionEdge(Edge edge, Stream resource, ConstantPoolGen cpg) {
        return false;
    }

    @Override
    public boolean isParamInstance(Stream resource, int slot) {
        return resource.getInstanceParam() == slot;
    }
}

