/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.LockDataflow;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.MultiThreadedCodeIdentifierUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class SharedVariableAtomicityDetector
extends OpcodeStackDetector {
    private final BugAccumulator bugAccumulator;
    private Method currentMethod;
    private CFG currentCFG;
    private LockDataflow currentLockDataFlow;
    private boolean isFirstVisit = true;
    private boolean hadOperation = false;
    private final Map<XMethod, Set<XField>> readFieldsByMethods = new HashMap<XMethod, Set<XField>>();
    private final Set<XField> relevantFields = new HashSet<XField>();
    private final Map<XMethod, Set<XMethod>> nonSyncedMethodCallsByCallingMethods = new HashMap<XMethod, Set<XMethod>>();
    private static final Set<Short> readOpCodes = Set.of((short)180, (short)178, (short)25, (short)42, (short)43, (short)44, (short)45, (short)24, (short)38, (short)39, (short)40, (short)41, (short)22, (short)30, (short)31, (short)32, (short)33, (short)23, (short)34, (short)35, (short)36, (short)37, (short)21, (short)26, (short)27, (short)28, (short)29, (short)49, (short)47, (short)48, (short)46);
    private static final Set<Short> pushOpCodes = Set.of((short)14, (short)15, (short)9, (short)10, (short)11, (short)12, (short)13, (short)3, (short)4, (short)5, (short)6, (short)7, (short)8, (short)18, (short)19, (short)20);
    private static final Set<Short> operationOpCodes = Set.of((short)99, (short)103, (short)107, (short)111, (short)115, (short)119, (short)98, (short)102, (short)106, (short)110, (short)114, (short)118, (short)97, (short)101, (short)105, (short)109, (short)113, (short)117, (short)96, (short)100, (short)104, (short)108, (short)112, (short)116, (short)120, (short)122, (short)124, (short)121, (short)123, (short)125, (short)126, (short)127, (short)128, (short)130, (short)129, (short)131);
    private static final Set<Short> methodCallOpCodes = Set.of(Short.valueOf((short)182), Short.valueOf((short)183), Short.valueOf((short)184), Short.valueOf((short)185));

    public SharedVariableAtomicityDetector(BugReporter reporter) {
        this.bugAccumulator = new BugAccumulator(reporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        if (MultiThreadedCodeIdentifierUtils.isPartOfMultiThreadedCode(classContext) && !MultiThreadedCodeIdentifierUtils.isNotThreadSafe(classContext)) {
            this.currentMethod = null;
            this.currentCFG = null;
            this.currentLockDataFlow = null;
            super.visitClassContext(classContext);
        }
    }

    @Override
    public void visit(JavaClass javaClass) {
        this.isFirstVisit = true;
        for (Method m : javaClass.getMethods()) {
            this.doVisitMethod(m);
        }
        this.isFirstVisit = false;
    }

    @Override
    public void visit(Method method) {
        try {
            this.relevantFields.clear();
            this.hadOperation = false;
            this.currentMethod = method;
            this.currentLockDataFlow = this.getClassContext().getLockDataflow(this.currentMethod);
            this.currentCFG = this.getClassContext().getCFG(this.currentMethod);
        }
        catch (CFGBuilderException | DataflowAnalysisException e) {
            AnalysisContext.logError("There was an error while SharedVariableAtomicityDetector analyzed " + this.getClassName(), e);
        }
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.bugAccumulator.reportAccumulatedBugs();
        this.relevantFields.clear();
        this.readFieldsByMethods.clear();
        this.hadOperation = false;
        this.nonSyncedMethodCallsByCallingMethods.clear();
    }

    @Override
    public void sawOpcode(int seen) {
        if ("<init>".equals(this.getMethodName()) || "<clinit>".equals(this.getMethodName()) || MultiThreadedCodeIdentifierUtils.isLocked(this.currentMethod, this.currentCFG, this.currentLockDataFlow, this.getPC())) {
            return;
        }
        XMethod method = this.getXMethod();
        if (this.isFirstVisit) {
            this.collectFieldReadsAndInnerMethodCalls(seen, method);
        } else {
            this.checkAndReportBug(seen, method);
        }
    }

    private void collectFieldReadsAndInnerMethodCalls(int seen, XMethod method) {
        XMethod calledMethod;
        if (seen == 180 || seen == 178) {
            this.addNonFinalFieldsOfClass(this.getXFieldOperand(), method, this.readFieldsByMethods);
        } else if (seen == 156 || seen == 157 || seen == 155 || seen == 158 || seen == 154 || seen == 153) {
            XField lhs = this.stack.getStackDepth() > 0 ? this.stack.getStackItem(0).getXField() : null;
            XField rhs = this.stack.getStackDepth() > 1 ? this.stack.getStackItem(1).getXField() : null;
            this.addNonFinalFieldsOfClass(lhs, method, this.readFieldsByMethods);
            this.addNonFinalFieldsOfClass(rhs, method, this.readFieldsByMethods);
        } else if (!(seen != 185 && seen != 183 && seen != 182 && seen != 184 || method.equals(calledMethod = this.getXMethodOperand()))) {
            this.nonSyncedMethodCallsByCallingMethods.computeIfAbsent(calledMethod, k -> new HashSet()).add(method);
        }
    }

    private void addNonFinalFieldsOfClass(XField field, XMethod method, Map<XMethod, Set<XField>> map) {
        if (field != null && !field.isFinal() && !field.isSynthetic() && field.getClassDescriptor().equals(method.getClassDescriptor())) {
            map.computeIfAbsent(method, k -> new HashSet()).add(field);
        }
    }

    private boolean hasNonSyncedNonPrivateCallToMethod(XMethod method, Set<XMethod> visitedMethods) {
        if (!method.isPrivate()) {
            return true;
        }
        boolean result = false;
        if (this.nonSyncedMethodCallsByCallingMethods.containsKey(method)) {
            for (XMethod callingMethod : this.nonSyncedMethodCallsByCallingMethods.get(method)) {
                if (visitedMethods.contains(callingMethod)) {
                    return false;
                }
                visitedMethods.add(callingMethod);
                result |= this.hasNonSyncedNonPrivateCallToMethod(callingMethod, visitedMethods);
                visitedMethods.remove(callingMethod);
            }
        }
        return result;
    }

    private boolean mapContainsFieldWithOtherMethod(XField field, XMethod method, Map<XMethod, Set<XField>> map) {
        return map.entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(field) && entry.getKey() != method).map(Map.Entry::getKey).anyMatch(m -> this.hasNonSyncedNonPrivateCallToMethod((XMethod)m, (Set<XMethod>)new HashSet<XMethod>()));
    }

    private void checkAndReportBug(int seen, XMethod method) {
        if (seen == 180 || seen == 178) {
            XField field = this.getXFieldOperand();
            if (field != null && !field.isSynthetic()) {
                this.relevantFields.add(field);
            }
        } else if (seen == 181 || seen == 179) {
            boolean fieldReadInOtherMethod;
            XField field = this.getXFieldOperand();
            if (field != null && !field.isFinal() && !field.isSynthetic() && (seen == 179 || this.stack.getStackItem(1).getRegisterNumber() == 0) && field.getClassDescriptor().equals(method.getClassDescriptor()) && this.hasNonSyncedNonPrivateCallToMethod(method, new HashSet<XMethod>()) && (fieldReadInOtherMethod = this.mapContainsFieldWithOtherMethod(field, method, this.readFieldsByMethods))) {
                if (this.hadOperation && !this.relevantFields.isEmpty() && this.relevantFields.contains(field) && this.isPrimitiveOrItsBoxingType(field.getSignature())) {
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "AT_NONATOMIC_OPERATIONS_ON_SHARED_VARIABLE", 2).addClass(this).addMethod(method).addField(field), this);
                } else if (!field.isVolatile() && ClassName.isValidBaseTypeFieldDescriptor(field.getSignature())) {
                    String bugType = this.is64bitPrimitive(field.getSignature()) ? "AT_NONATOMIC_64BIT_PRIMITIVE" : "AT_STALE_THREAD_WRITE_OF_PRIMITIVE";
                    this.bugAccumulator.accumulateBug(new BugInstance(this, bugType, 2).addClass(this).addMethod(method).addField(field), this);
                }
            }
            this.relevantFields.clear();
        } else {
            short opcode = (short)seen;
            if (operationOpCodes.contains(opcode)) {
                if (!this.relevantFields.isEmpty()) {
                    this.hadOperation = true;
                }
            } else if (!(readOpCodes.contains(opcode) || pushOpCodes.contains(opcode) || methodCallOpCodes.contains(opcode))) {
                this.relevantFields.clear();
                this.hadOperation = false;
            }
        }
    }

    private boolean isPrimitiveOrItsBoxingType(String className) {
        if (ClassName.isValidBaseTypeFieldDescriptor(className)) {
            return true;
        }
        String clsName = ClassName.fromFieldSignature(className);
        return clsName != null && ClassName.isValidBaseTypeFieldDescriptor(ClassName.getPrimitiveType(clsName));
    }

    private boolean is64bitPrimitive(String className) {
        return "D".equals(className) || "J".equals(className);
    }
}

