/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.util.BootstrapMethodsUtil;
import edu.umd.cs.findbugs.util.CollectionAnalysis;
import edu.umd.cs.findbugs.util.MethodAnalysis;
import edu.umd.cs.findbugs.util.MutableClasses;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class ResourceInMultipleThreadsDetector
extends OpcodeStackDetector {
    private final BugReporter bugReporter;
    private final Set<XField> synchronizedCollectionTypedFields = new HashSet<XField>();
    private final Map<XMethod, Set<XMethod>> calledMethodsByMethods = new HashMap<XMethod, Set<XMethod>>();
    private final Set<XMethod> methodsUsedInThreads = new HashSet<XMethod>();
    private final Map<XField, FieldData> fieldsUsedInThreads = new HashMap<XField, FieldData>();
    private boolean synchronizedBlock = false;
    private boolean firstPass = true;

    public ResourceInMultipleThreadsDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(JavaClass obj) {
        this.resetState();
        for (Method m : obj.getMethods()) {
            this.doVisitMethod(m);
        }
        this.firstPass = false;
    }

    @Override
    public void visit(Method method) {
        this.synchronizedBlock = method.isSynchronized();
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 194) {
            this.synchronizedBlock = true;
        } else if (seen == 195) {
            this.synchronizedBlock = false;
        }
        if (this.firstPass) {
            this.collectMethodsUsedInThreads(seen);
        } else {
            try {
                this.collectFieldsUsedInThreads(seen);
            }
            catch (CheckedAnalysisException e) {
                this.bugReporter.logError(String.format("Detector %s caught exception while analyzing class %s", this.getClass().getName(), this.getClassName()), e);
            }
        }
    }

    private void collectMethodsUsedInThreads(int seen) {
        XMethod calledMethod;
        if (seen == 186) {
            JavaClass javaClass = this.getThisClass();
            Optional<Method> lambdaMethod = this.getMethodFromBootstrap(javaClass, (ConstantInvokeDynamic)this.getConstantRefOperand());
            if (lambdaMethod.isPresent()) {
                XMethod lambdaXMethod = XFactory.createXMethod(javaClass, lambdaMethod.get());
                this.calledMethodsByMethods.computeIfAbsent(this.getXMethod(), v -> new HashSet()).add(lambdaXMethod);
                if (this.getStack().getStackDepth() > 1 && "Ljava/lang/Thread;".equals(this.getStack().getStackItem(1).getSignature()) && !this.isJavaRuntimeMethod()) {
                    this.addToMethodsUsedInThreads(lambdaXMethod);
                }
            }
        } else if ((seen == 182 || seen == 185 || seen == 183 || seen == 184) && (calledMethod = this.getXMethodOperand()) != null) {
            this.calledMethodsByMethods.computeIfAbsent(this.getXMethod(), v -> new HashSet()).add(calledMethod);
            if (this.methodsUsedInThreads.contains(this.getXMethod()) && this.getClassDescriptor().equals(calledMethod.getClassDescriptor())) {
                this.addToMethodsUsedInThreads(calledMethod);
            }
        }
    }

    private void addToMethodsUsedInThreads(XMethod methodToAdd) {
        this.methodsUsedInThreads.add(methodToAdd);
        if (this.calledMethodsByMethods.containsKey(methodToAdd)) {
            this.methodsUsedInThreads.addAll((Collection<XMethod>)this.calledMethodsByMethods.get(methodToAdd));
        }
    }

    private boolean isJavaRuntimeMethod() {
        return IntStream.range(0, this.getStack().getStackDepth()).mapToObj(this.getStack()::getStackItem).map(OpcodeStack.Item::getReturnValueOf).filter(Objects::nonNull).anyMatch(method -> "java.lang.Runtime".equals(method.getClassName()));
    }

    private Optional<Method> getMethodFromBootstrap(JavaClass javaClass, ConstantInvokeDynamic constDyn) {
        for (Attribute attr : javaClass.getAttributes()) {
            if (!(attr instanceof BootstrapMethods)) continue;
            return BootstrapMethodsUtil.getMethodFromBootstrap((BootstrapMethods)attr, constDyn.getBootstrapMethodAttrIndex(), this.getConstantPool(), javaClass);
        }
        return Optional.empty();
    }

    private void collectFieldsUsedInThreads(int seen) throws CheckedAnalysisException {
        XField xField;
        if ((seen == 181 || seen == 179) && this.getStack().getStackDepth() > 0 && !MethodAnalysis.isDuplicatedLocation(this.getMethodDescriptor(), this.getPC()) && this.methodsUsedInThreads.contains(this.getXMethod())) {
            OpcodeStack.Item stackItem = this.getStack().getStackItem(0);
            XField field = this.getXFieldOperand();
            if (field != null) {
                if (stackItem.getReturnValueOf() != null && CollectionAnalysis.isSynchronizedCollection(stackItem.getReturnValueOf())) {
                    this.synchronizedCollectionTypedFields.add(field);
                } else if (!(this.isAtomicTypedField(field) || "<init>".equals(this.getMethodName()) || "<clinit>".equals(this.getMethodName()))) {
                    this.createOrUpdateFieldData(field, true, this.getMethod(), this.getXMethodOperand());
                }
            }
        } else if (!(seen != 182 && seen != 185 && seen != 183 && seen != 184 || this.getXMethodOperand() == null || this.getStack().getStackDepth() <= 0 || MethodAnalysis.isDuplicatedLocation(this.getMethodDescriptor(), this.getPC()) || !this.methodsUsedInThreads.contains(this.getXMethod()) || (xField = this.getStack().getStackItem(this.getStack().getStackDepth() - 1).getXField()) == null || this.isAtomicTypedField(xField))) {
            this.createOrUpdateFieldData(xField, false, this.getMethod(), this.getXMethodOperand());
        }
    }

    private boolean isAtomicTypedField(XField xField) {
        return xField.getSignature().contains("java/util/concurrent/atomic") || this.synchronizedCollectionTypedFields.contains(xField);
    }

    private void createOrUpdateFieldData(XField xField, boolean putfield, Method containerMethod, XMethod xMethod) {
        BugInstance bug = new BugInstance(this, "AT_UNSAFE_RESOURCE_ACCESS_IN_THREAD", 3).addClassAndMethod(this).addSourceLine(this).addField(xField);
        if (!putfield) {
            bug.addCalledMethod(this);
        }
        FieldData data = this.fieldsUsedInThreads.computeIfAbsent(xField, value -> new FieldData());
        data.methodBugs.computeIfAbsent(containerMethod, value -> new HashSet()).add(bug);
        data.onlySynchronized &= this.synchronizedBlock;
        data.onlyPutField &= putfield;
        data.modified = data.modified | (putfield || xMethod != null && MutableClasses.looksLikeASetter(xMethod.getName()));
    }

    @Override
    public void visitAfter(JavaClass javaClass) {
        super.visit(javaClass);
        this.fieldsUsedInThreads.entrySet().stream().filter(entry -> ResourceInMultipleThreadsDetector.isBug((FieldData)entry.getValue())).flatMap(entry -> ((FieldData)entry.getValue()).methodBugs.values().stream().flatMap(Collection::stream)).collect(Collectors.toSet()).forEach(this.bugReporter::reportBug);
    }

    private static boolean isBug(FieldData data) {
        return data.modified && !data.onlySynchronized && data.methodBugs.size() > 1 && !data.onlyPutField;
    }

    private void resetState() {
        this.firstPass = true;
        this.synchronizedCollectionTypedFields.clear();
        this.methodsUsedInThreads.clear();
        this.fieldsUsedInThreads.clear();
        this.calledMethodsByMethods.clear();
    }

    private static final class FieldData {
        private boolean modified = false;
        private boolean onlySynchronized = true;
        private boolean onlyPutField = true;
        private final Map<Method, Set<BugInstance>> methodBugs = new HashMap<Method, Set<BugInstance>>();

        private FieldData() {
        }
    }
}

