/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.OpcodeStackScanner;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.type.TypeFrameModelingVisitor;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.MutableClasses;
import edu.umd.cs.findbugs.util.NestedAccessUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;

public class FindReturnRef
extends OpcodeStackDetector {
    private boolean check = false;
    private boolean staticMethod = false;
    private int parameterCount;
    private XField fieldUnderClone = null;
    private OpcodeStack.Item paramUnderClone = null;
    private XField fieldCloneUnderCast = null;
    private OpcodeStack.Item paramCloneUnderCast = null;
    private XField bufferFieldUnderDuplication = null;
    private OpcodeStack.Item bufferParamUnderDuplication = null;
    private XField fieldUnderWrapToBuffer = null;
    private OpcodeStack.Item paramUnderWrapToBuffer = null;
    private final Map<OpcodeStack.Item, XField> bufferFieldDuplicates = new HashMap<OpcodeStack.Item, XField>();
    private final Map<OpcodeStack.Item, OpcodeStack.Item> bufferParamDuplicates = new HashMap<OpcodeStack.Item, OpcodeStack.Item>();
    private final Map<OpcodeStack.Item, XField> arrayFieldsWrappedToBuffers = new HashMap<OpcodeStack.Item, XField>();
    private final Map<OpcodeStack.Item, OpcodeStack.Item> arrayParamsWrappedToBuffers = new HashMap<OpcodeStack.Item, OpcodeStack.Item>();
    private final Map<OpcodeStack.Item, XField> arrayFieldClones = new HashMap<OpcodeStack.Item, XField>();
    private final Map<OpcodeStack.Item, OpcodeStack.Item> arrayParamClones = new HashMap<OpcodeStack.Item, OpcodeStack.Item>();
    private final Map<XField, List<OpcodeStack.Item>> fieldValues = new HashMap<XField, List<OpcodeStack.Item>>();
    private final BugAccumulator bugAccumulator;
    private static final Pattern BUFFER_CLASS_PATTERN = Pattern.compile("Ljava/nio/[A-Za-z]+Buffer;");
    private static final Pattern DUPLICATE_METHODS_SIGNATURE_PATTERN = Pattern.compile("\\(\\)Ljava/nio/[A-Za-z]+Buffer;");
    private static final Pattern WRAP_METHOD_SIGNATURE_PATTERN = Pattern.compile("\\(\\[.\\)Ljava/nio/[A-Za-z]+Buffer;");

    public FindReturnRef(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void visit(JavaClass obj) {
        for (Method m : obj.getMethods()) {
            this.collectData(obj, m);
        }
    }

    private void collectData(JavaClass javaClass, Method m) {
        try {
            CFG cfg = this.getClassContext().getCFG(m);
            ConstantPoolGen cpg = this.getClassContext().getConstantPoolGen();
            Iterator<Location> loci = cfg.locationIterator();
            while (loci.hasNext()) {
                Location loc = loci.next();
                InstructionHandle ih = loc.getHandle();
                Instruction ins = ih.getInstruction();
                if (!(ins instanceof PUTFIELD) && !(ins instanceof PUTSTATIC)) continue;
                int pc = ih.getPosition();
                OpcodeStack currentStack = OpcodeStackScanner.getStackAt(javaClass, m, pc);
                XField field = XFactory.createXField((FieldInstruction)ins, cpg);
                this.fieldValues.computeIfAbsent(field, k -> new ArrayList());
                if (!currentStack.isTop()) {
                    this.fieldValues.get(field).add(currentStack.getStackItem(0));
                }
                if (!currentStack.hasIncomingBranches(pc)) continue;
                Iterator<BasicBlock> bi = cfg.predecessorIterator(loc.getBasicBlock());
                while (bi.hasNext()) {
                    OpcodeStack prevStack;
                    BasicBlock previousBlock = bi.next();
                    InstructionHandle lastInstruction = previousBlock.getLastInstruction();
                    if (!ih.hasTargeters() || lastInstruction == null || (prevStack = OpcodeStackScanner.getStackAt(javaClass, m, lastInstruction.getPosition())).getStackDepth() <= 1) continue;
                    this.fieldValues.get(field).add(prevStack.getStackItem(0));
                }
            }
        }
        catch (CFGBuilderException e) {
            AnalysisContext.logError(String.format("Error happened while analyzing %s", javaClass.getClassName()), e);
        }
    }

    @Override
    public void visit(Method obj) {
        boolean bl = this.check = this.getThisClass().isPublic() && obj.isPublic();
        if (!this.check) {
            return;
        }
        this.staticMethod = obj.isStatic();
        this.parameterCount = this.getNumberMethodArguments();
        if (!this.staticMethod) {
            ++this.parameterCount;
        }
        super.visit(obj);
    }

    @Override
    public void sawOpcode(int seen) {
        MethodDescriptor method;
        XField field;
        OpcodeStack.Item item;
        OpcodeStack.Item top;
        CaptureKind capture;
        if (!this.check) {
            return;
        }
        this.fieldUnderClone = null;
        this.paramUnderClone = null;
        this.fieldCloneUnderCast = null;
        this.paramCloneUnderCast = null;
        this.fieldUnderWrapToBuffer = null;
        this.paramUnderWrapToBuffer = null;
        this.bufferFieldUnderDuplication = null;
        this.bufferParamUnderDuplication = null;
        if (this.staticMethod && seen == 179 && this.nonPublicFieldOperand() && MutableClasses.mutableSignature(this.getSigConstantOperand()) && (capture = this.getPotentialCapture(top = this.stack.getStackItem(0))) != CaptureKind.NONE) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "EI_EXPOSE_STATIC_" + (capture == CaptureKind.BUF ? "BUF2" : "REP2"), capture == CaptureKind.REP ? 2 : 3).addClassAndMethod(this).addReferencedField(this).add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), top.getRegisterNumber(), this.getPC(), this.getPC() - 1)), this);
        }
        if (!this.staticMethod && seen == 181 && this.nonPublicFieldOperand() && MutableClasses.mutableSignature(this.getSigConstantOperand())) {
            top = this.stack.getStackItem(0);
            OpcodeStack.Item target = this.stack.getStackItem(1);
            CaptureKind capture2 = this.getPotentialCapture(top);
            if (capture2 != CaptureKind.NONE && (target.getRegisterNumber() == 0 || this.isNestedField(target.getXField()))) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "EI_EXPOSE_" + (capture2 == CaptureKind.BUF ? "BUF2" : "REP2"), capture2 == CaptureKind.REP ? 2 : 3).addClassAndMethod(this).addReferencedField(this).add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), top.getRegisterNumber(), this.getPC(), this.getPC() - 1)), this);
            }
        }
        if (seen == 176) {
            item = this.stack.getStackItem(0);
            field = item.getXField();
            boolean isBuf = false;
            boolean isArrayClone = false;
            if (field == null && (field = this.arrayFieldClones.get(item)) != null) {
                isArrayClone = true;
            }
            if (field == null && (field = this.bufferFieldDuplicates.get(item)) != null) {
                isBuf = true;
            }
            if (field == null && (field = this.arrayFieldsWrappedToBuffers.get(item)) != null) {
                isBuf = true;
            }
            if (field == null || !this.isFieldOf(field, this.getClassDescriptor()) || field.isPublic() || AnalysisContext.currentXFactory().isEmptyArrayField(field) || field.getName().contains("EMPTY") || !MutableClasses.mutableSignature(TypeFrameModelingVisitor.getType(field).getSignature())) {
                return;
            }
            if (this.fieldValues.containsKey(field) && this.fieldValues.get(field).stream().noneMatch(it -> MutableClasses.mutableSignature(it.getSignature()))) {
                return;
            }
            this.bugAccumulator.accumulateBug(new BugInstance(this, (this.staticMethod ? "MS" : "EI") + "_EXPOSE_" + (isBuf ? "BUF" : "REP"), isBuf || isArrayClone ? 3 : 2).addClassAndMethod(this).addField(field.getClassName(), field.getName(), field.getSignature(), field.isStatic()), this);
        }
        if (seen == 185 || seen == 182) {
            method = this.getMethodDescriptorOperand();
            OpcodeStack.Item item2 = this.stack.getStackItem(0);
            XField field2 = item2.getXField();
            if (method == null) {
                return;
            }
            if ("clone".equals(method.getName()) && item2.isArray() && MutableClasses.mutableSignature(item2.getSignature().substring(1))) {
                if (field2 != null && !field2.isPublic() && this.isFieldOf(field2, this.getClassDescriptor())) {
                    this.fieldUnderClone = field2;
                } else if (item2.isInitialParameter()) {
                    this.paramUnderClone = item2;
                }
            }
            if (seen == 182 && "duplicate".equals(method.getName()) && DUPLICATE_METHODS_SIGNATURE_PATTERN.matcher(method.getSignature()).matches() && BUFFER_CLASS_PATTERN.matcher(method.getClassDescriptor().getSignature()).matches()) {
                if (field2 != null && !field2.isPublic() && this.isFieldOf(field2, this.getClassDescriptor())) {
                    this.bufferFieldUnderDuplication = field2;
                } else if (item2.isInitialParameter()) {
                    this.bufferParamUnderDuplication = item2;
                }
            }
        }
        if (seen == 184) {
            method = this.getMethodDescriptorOperand();
            if (!(method != null && "wrap".equals(method.getName()) && WRAP_METHOD_SIGNATURE_PATTERN.matcher(method.getSignature()).matches() && BUFFER_CLASS_PATTERN.matcher(method.getClassDescriptor().getSignature()).matches())) {
                return;
            }
            OpcodeStack.Item arg = this.stack.getStackItem(0);
            XField fieldArg = arg.getXField();
            if (fieldArg != null && !fieldArg.isPublic() && this.isFieldOf(fieldArg, this.getClassDescriptor())) {
                this.fieldUnderWrapToBuffer = fieldArg;
            } else if (arg.isInitialParameter()) {
                this.paramUnderWrapToBuffer = arg;
            }
        }
        if (seen == 192) {
            OpcodeStack.Item param;
            item = this.stack.getStackItem(0);
            field = this.arrayFieldClones.get(item);
            if (field != null) {
                this.fieldCloneUnderCast = field;
            }
            if ((param = this.arrayParamClones.get(item)) != null) {
                this.paramCloneUnderCast = param;
            }
        }
    }

    private boolean isNestedField(XField field) {
        if (field != null && this.getThisClass().isNested() && field.getName().startsWith("this$")) {
            try {
                List<JavaClass> hostClasses = NestedAccessUtil.getHostClasses(this.getThisClass());
                String fieldType = ClassName.fromFieldSignatureToDottedClassName(field.getSignature());
                return hostClasses.stream().anyMatch(t -> t.getClassName().equals(fieldType));
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.logError("Error looking for class", e);
            }
        }
        return false;
    }

    @Override
    public void afterOpcode(int seen) {
        super.afterOpcode(seen);
        if (seen == 185 || seen == 182) {
            if (this.fieldUnderClone != null) {
                this.arrayFieldClones.put(this.stack.getStackItem(0), this.fieldUnderClone);
            }
            if (this.paramUnderClone != null) {
                this.arrayParamClones.put(this.stack.getStackItem(0), this.paramUnderClone);
            }
            if (seen == 182) {
                if (this.bufferFieldUnderDuplication != null) {
                    this.bufferFieldDuplicates.put(this.stack.getStackItem(0), this.bufferFieldUnderDuplication);
                }
                if (this.bufferParamUnderDuplication != null) {
                    this.bufferParamDuplicates.put(this.stack.getStackItem(0), this.bufferParamUnderDuplication);
                }
            }
        }
        if (seen == 184) {
            if (this.fieldUnderWrapToBuffer != null) {
                this.arrayFieldsWrappedToBuffers.put(this.stack.getStackItem(0), this.fieldUnderWrapToBuffer);
            }
            if (this.paramUnderWrapToBuffer != null) {
                this.arrayParamsWrappedToBuffers.put(this.stack.getStackItem(0), this.paramUnderWrapToBuffer);
            }
        }
        if (seen == 192 && !this.stack.isTop()) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            if (this.fieldCloneUnderCast != null) {
                this.arrayFieldClones.put(item, this.fieldCloneUnderCast);
            }
            if (this.paramCloneUnderCast != null) {
                this.arrayParamClones.put(item, this.paramCloneUnderCast);
            }
        }
    }

    private boolean nonPublicFieldOperand() {
        XField xField = this.getXFieldOperand();
        return xField == null || !xField.isPublic();
    }

    private CaptureKind getPotentialCapture(OpcodeStack.Item top) {
        CaptureKind kind = CaptureKind.REP;
        if (!top.isInitialParameter()) {
            OpcodeStack.Item newTop = this.arrayParamClones.get(top);
            if (newTop == null) {
                newTop = this.arrayParamsWrappedToBuffers.get(top);
                if (newTop == null && (newTop = this.bufferParamDuplicates.get(top)) == null) {
                    return CaptureKind.NONE;
                }
                kind = CaptureKind.BUF;
            } else {
                kind = CaptureKind.ARRAY_CLONE;
            }
            top = newTop;
        }
        if (!this.getMethod().isVarArgs()) {
            return kind;
        }
        return top.getRegisterNumber() != this.parameterCount - 1 ? kind : CaptureKind.NONE;
    }

    private boolean isFieldOf(XField field, ClassDescriptor clazz) {
        do {
            ClassDescriptor clazz2 = clazz;
            do {
                if (field.getClassDescriptor().equals(clazz2)) {
                    return true;
                }
                try {
                    clazz2 = clazz2.getXClass().getSuperclassDescriptor();
                }
                catch (CheckedAnalysisException e) {
                    AnalysisContext.logError("Error checking for class " + String.valueOf(clazz2), e);
                    return false;
                }
            } while (clazz2 != null);
            try {
                clazz = clazz.getXClass().getImmediateEnclosingClass();
                if (clazz != null && !clazz.getXClass().isPublic()) {
                    return false;
                }
            }
            catch (CheckedAnalysisException e) {
                AnalysisContext.logError("Error checking for class " + String.valueOf(clazz), e);
                return false;
            }
        } while (clazz != null);
        return false;
    }

    private static enum CaptureKind {
        NONE,
        REP,
        ARRAY_CLONE,
        BUF;

    }
}

