/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;

public class FindCircularDependencies
extends BytecodeScanningDetector {
    private HashMap<String, Set<String>> dependencyGraph = null;
    private final BugReporter bugReporter;
    private String className;

    public FindCircularDependencies(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.dependencyGraph = new HashMap();
    }

    @Override
    public void visit(JavaClass obj) {
        this.className = obj.getClassName();
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 183 || seen == 184 || seen == 182) {
            String refClsName = this.getClassConstantOperand();
            if ((refClsName = ClassName.toDottedClassName(refClsName)).startsWith("java")) {
                return;
            }
            if (this.className.equals(refClsName)) {
                return;
            }
            if (this.className.startsWith(refClsName) && refClsName.indexOf(36) >= 0) {
                return;
            }
            if (refClsName.startsWith(this.className) && this.className.indexOf(36) >= 0) {
                return;
            }
            Set dependencies = this.dependencyGraph.computeIfAbsent(this.className, k -> new HashSet());
            dependencies.add(refClsName);
        }
    }

    @Override
    public void report() {
        this.removeDependencyLeaves(this.dependencyGraph);
        LoopFinder lf = new LoopFinder();
        while (this.dependencyGraph.size() > 0) {
            boolean pruneLeaves;
            String clsName = this.dependencyGraph.keySet().iterator().next();
            Set<String> loop = lf.findLoop(this.dependencyGraph, clsName);
            if (loop != null) {
                BugInstance bug = new BugInstance(this, "CD_CIRCULAR_DEPENDENCY", 2);
                for (String loopCls : loop) {
                    bug.addClass(loopCls);
                }
                this.bugReporter.reportBug(bug);
                pruneLeaves = this.removeLoopLinks(this.dependencyGraph, loop);
            } else {
                this.dependencyGraph.remove(clsName);
                pruneLeaves = true;
            }
            if (!pruneLeaves) continue;
            this.removeDependencyLeaves(this.dependencyGraph);
        }
        this.dependencyGraph.clear();
    }

    private void removeDependencyLeaves(Map<String, Set<String>> dependencyGraph) {
        boolean changed = true;
        while (changed) {
            changed = false;
            Iterator<Set<String>> it = dependencyGraph.values().iterator();
            while (it.hasNext()) {
                Set<String> dependencies = it.next();
                boolean foundClass = false;
                Iterator<String> dit = dependencies.iterator();
                while (dit.hasNext()) {
                    foundClass = dependencyGraph.containsKey(dit.next());
                    if (foundClass) continue;
                    dit.remove();
                    changed = true;
                }
                if (!dependencies.isEmpty()) continue;
                it.remove();
                changed = true;
            }
        }
    }

    private boolean removeLoopLinks(Map<String, Set<String>> dependencyGraph, Set<String> loop) {
        Set<String> dependencies = null;
        for (String clsName : loop) {
            if (dependencies != null) {
                dependencies.remove(clsName);
            }
            dependencies = dependencyGraph.get(clsName);
        }
        if (dependencies != null) {
            dependencies.remove(loop.iterator().next());
        }
        boolean removedClass = false;
        Iterator<String> cIt = loop.iterator();
        while (cIt.hasNext()) {
            String clsName = cIt.next();
            dependencies = dependencyGraph.get(clsName);
            if (!dependencies.isEmpty()) continue;
            cIt.remove();
            removedClass = true;
        }
        return removedClass;
    }

    static class LoopFinder {
        private Map<String, Set<String>> dGraph = null;
        private String startClass = null;
        private Set<String> visited = null;
        private Set<String> loop = null;

        LoopFinder() {
        }

        public Set<String> findLoop(Map<String, Set<String>> dependencyGraph, String startCls) {
            this.dGraph = dependencyGraph;
            this.startClass = startCls;
            this.visited = new HashSet<String>();
            this.loop = new LinkedHashSet<String>();
            if (this.findLoop(this.startClass)) {
                return this.loop;
            }
            return null;
        }

        private boolean findLoop(String curClass) {
            Set<String> dependencies = this.dGraph.get(curClass);
            if (dependencies == null) {
                return false;
            }
            this.visited.add(curClass);
            this.loop.add(curClass);
            for (String depClass : dependencies) {
                if (depClass.equals(this.startClass)) {
                    return true;
                }
                if (this.visited.contains(depClass) || !this.findLoop(depClass)) continue;
                return true;
            }
            this.loop.remove(curClass);
            return false;
        }
    }
}

