/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.detect.AbstractAssertDetector;
import org.apache.bcel.classfile.JavaClass;

public class FindArgumentAssertions
extends AbstractAssertDetector {
    public FindArgumentAssertions(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        JavaClass ctx = classContext.getJavaClass();
        if (!ctx.isPublic()) {
            return;
        }
        super.visitClassContext(classContext);
    }

    private boolean isInitialArg() {
        XMethod m = this.getXMethodOperand();
        if (m != null) {
            int numPar = m.getNumParams();
            for (int i = 0; i < numPar; ++i) {
                OpcodeStack.Item item = this.stack.getStackItem(i);
                if (!item.isInitialParameter()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMethodCall(int seen) {
        return seen == 184 || seen == 182 || seen == 185 || seen == 183;
    }

    private int checkSeen(int seen) {
        int stackSize;
        switch (seen) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                stackSize = 1;
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                stackSize = 2;
                break;
            }
            default: {
                stackSize = 0;
            }
        }
        return stackSize;
    }

    @Override
    protected void detect(int seen) {
        boolean wasArg = false;
        XMethod method = this.getXMethod();
        if (!method.isPublic()) {
            return;
        }
        if (this.isMethodCall(seen)) {
            wasArg = this.isInitialArg();
        } else {
            int stackSize = this.checkSeen(seen);
            if (stackSize > 0) {
                OpcodeStack.Item item;
                for (int i = 0; i < stackSize && !(wasArg = (item = this.stack.getStackItem(i)).isInitialParameter()); ++i) {
                }
            }
        }
        if (wasArg) {
            BugInstance bug = new BugInstance(this, "AA_ASSERTION_OF_ARGUMENTS", 3).addClassAndMethod(this).addSourceLine(this, this.getPC());
            this.reportBug(bug);
        }
    }
}

