/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IClassFactory;
import edu.umd.cs.findbugs.classfile.IClassPath;
import edu.umd.cs.findbugs.classfile.IClassPathBuilder;
import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.ICodeBaseLocator;
import edu.umd.cs.findbugs.classfile.IErrorLogger;
import edu.umd.cs.findbugs.classfile.IScannableCodeBase;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.impl.AnalysisCache;
import edu.umd.cs.findbugs.classfile.impl.ClassPathBuilder;
import edu.umd.cs.findbugs.classfile.impl.ClassPathImpl;
import edu.umd.cs.findbugs.classfile.impl.DirectoryCodeBase;
import edu.umd.cs.findbugs.classfile.impl.EmptyCodeBase;
import edu.umd.cs.findbugs.classfile.impl.FilesystemCodeBaseLocator;
import edu.umd.cs.findbugs.classfile.impl.JrtfsCodeBase;
import edu.umd.cs.findbugs.classfile.impl.NestedZipFileCodeBase;
import edu.umd.cs.findbugs.classfile.impl.NestedZipFileCodeBaseLocator;
import edu.umd.cs.findbugs.classfile.impl.SingleFileCodeBase;
import edu.umd.cs.findbugs.classfile.impl.ZipCodeBaseFactory;
import java.io.File;
import java.io.IOException;

public class ClassFactory
implements IClassFactory {
    private static IClassFactory theInstance = new ClassFactory();

    private ClassFactory() {
    }

    public static IClassFactory instance() {
        return theInstance;
    }

    @Override
    public IClassPath createClassPath() {
        return new ClassPathImpl();
    }

    @Override
    public IClassPathBuilder createClassPathBuilder(IErrorLogger errorLogger) {
        return new ClassPathBuilder(this, errorLogger);
    }

    @Override
    public ICodeBaseLocator createFilesystemCodeBaseLocator(String pathName) {
        return new FilesystemCodeBaseLocator(pathName);
    }

    @Override
    public ICodeBaseLocator createNestedArchiveCodeBaseLocator(ICodeBase parentCodeBase, String path) {
        return new NestedZipFileCodeBaseLocator(parentCodeBase, path);
    }

    static IScannableCodeBase createFilesystemCodeBase(FilesystemCodeBaseLocator codeBaseLocator) throws IOException {
        String fileName = codeBaseLocator.getPathName();
        File file = new File(fileName);
        if (!file.exists() || !file.canRead()) {
            return ClassFactory.createEmptyCodeBase(codeBaseLocator, file);
        }
        if (file.isDirectory()) {
            return new DirectoryCodeBase(codeBaseLocator, file);
        }
        if (!file.isFile()) {
            return ClassFactory.createEmptyCodeBase(codeBaseLocator, file);
        }
        if (fileName.endsWith(".class")) {
            return new SingleFileCodeBase(codeBaseLocator, fileName);
        }
        if (fileName.endsWith(File.separator + "jrt-fs.jar")) {
            return new JrtfsCodeBase(codeBaseLocator, fileName);
        }
        try {
            return ZipCodeBaseFactory.makeZipCodeBase(codeBaseLocator, file);
        }
        catch (IOException e) {
            return ClassFactory.createEmptyCodeBase(codeBaseLocator, file);
        }
    }

    private static IScannableCodeBase createEmptyCodeBase(FilesystemCodeBaseLocator codeBaseLocator, File file) {
        if (FindBugs2.DEBUG) {
            System.out.println("Ignoring unreadable or non-existent file " + String.valueOf(file));
        }
        return new EmptyCodeBase(codeBaseLocator);
    }

    static IScannableCodeBase createNestedZipFileCodeBase(NestedZipFileCodeBaseLocator codeBaseLocator) throws ResourceNotFoundException, IOException {
        return new NestedZipFileCodeBase(codeBaseLocator);
    }

    @Override
    public IAnalysisCache createAnalysisCache(IClassPath classPath, BugReporter errorLogger) {
        return new AnalysisCache(classPath, errorLogger);
    }
}

