/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.charsets;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.WillCloseWhenClosed;

public class UTF8 {
    public static PrintStream printStream(OutputStream out) {
        return UTF8.printStream(out, false);
    }

    public static PrintStream printStream(OutputStream out, boolean autoflush) {
        return new PrintStream(out, autoflush, StandardCharsets.UTF_8);
    }

    public static Writer writer(OutputStream out) {
        return new OutputStreamWriter(out, StandardCharsets.UTF_8);
    }

    public static Writer fileWriter(File fileName) throws IOException {
        return new OutputStreamWriter(Files.newOutputStream(fileName.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
    }

    public static BufferedWriter bufferedWriter(File fileName) throws IOException {
        return new BufferedWriter(UTF8.fileWriter(fileName));
    }

    public static PrintWriter printWriter(File fileName) throws IOException {
        return new PrintWriter(UTF8.bufferedWriter(fileName));
    }

    public static PrintWriter printWriter(PrintStream printStream) {
        return new PrintWriter(new OutputStreamWriter((OutputStream)printStream, StandardCharsets.UTF_8));
    }

    public static PrintWriter printWriter(PrintStream printStream, boolean autoflush) {
        return new PrintWriter((Writer)new OutputStreamWriter((OutputStream)printStream, StandardCharsets.UTF_8), autoflush);
    }

    public static Writer fileWriter(String fileName) throws IOException {
        return new OutputStreamWriter(Files.newOutputStream(Path.of(fileName, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);
    }

    public static BufferedWriter bufferedWriter(String fileName) throws IOException {
        return new BufferedWriter(UTF8.fileWriter(fileName));
    }

    public static Reader fileReader(String fileName) throws IOException {
        return UTF8.reader(Files.newInputStream(Path.of(fileName, new String[0]), new OpenOption[0]));
    }

    public static Reader fileReader(File fileName) throws IOException {
        return UTF8.reader(Files.newInputStream(fileName.toPath(), new OpenOption[0]));
    }

    public static PrintWriter printWriter(String fileName) throws IOException {
        return new PrintWriter(UTF8.bufferedWriter(fileName));
    }

    public static Reader reader(@WillCloseWhenClosed InputStream in) {
        return new InputStreamReader(in, StandardCharsets.UTF_8);
    }

    public static BufferedReader bufferedReader(@WillCloseWhenClosed InputStream in) {
        return new BufferedReader(UTF8.reader(in));
    }

    public static byte[] getBytes(String s) {
        return StandardCharsets.UTF_8.encode(s).array();
    }
}

