/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.BackwardDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Debug;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import java.util.BitSet;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.StoreInstruction;

public class LiveLocalStoreAnalysis
extends BackwardDataflowAnalysis<BitSet>
implements Debug {
    private final int topBit;
    private final int killedByStoreOffset;

    public LiveLocalStoreAnalysis(MethodGen methodGen, ReverseDepthFirstSearch rdfs, DepthFirstSearch dfs) {
        super(rdfs, dfs);
        this.topBit = methodGen.getMaxLocals() * 2;
        this.killedByStoreOffset = methodGen.getMaxLocals();
    }

    @Override
    public BitSet createFact() {
        return new BitSet();
    }

    @Override
    public void copy(BitSet source, BitSet dest) {
        dest.clear();
        dest.or(source);
    }

    @Override
    public void initEntryFact(BitSet result) throws DataflowAnalysisException {
        result.clear();
    }

    @Override
    public void makeFactTop(BitSet fact) {
        fact.clear();
        fact.set(this.topBit);
    }

    @Override
    public boolean same(BitSet fact1, BitSet fact2) {
        return fact1.equals(fact2);
    }

    @Override
    public void meetInto(BitSet fact, Edge edge, BitSet result) throws DataflowAnalysisException {
        this.verifyFact(fact);
        this.verifyFact(result);
        if (!this.isTop(fact)) {
            if (this.isTop(result)) {
                this.copy(fact, result);
            } else {
                result.or(fact);
            }
        }
        this.verifyFact(result);
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, BitSet fact) throws DataflowAnalysisException {
        int local;
        if (!this.isFactValid(fact)) {
            return;
        }
        Instruction ins = handle.getInstruction();
        if (ins instanceof StoreInstruction) {
            LocalVariableInstruction store = (LocalVariableInstruction)ins;
            local = store.getIndex();
            fact.clear(local);
            fact.set(local + this.killedByStoreOffset);
        }
        if (ins instanceof LoadInstruction || ins instanceof IINC || ins instanceof RET) {
            IndexedInstruction load = (IndexedInstruction)ins;
            local = load.getIndex();
            fact.set(local);
            fact.clear(local + this.killedByStoreOffset);
        }
        if (!this.isFactValid(fact)) {
            throw new IllegalStateException("Fact become invalid");
        }
    }

    @Override
    public boolean isFactValid(BitSet fact) {
        this.verifyFact(fact);
        return !this.isTop(fact);
    }

    private void verifyFact(BitSet fact) {
        if (VERIFY_INTEGRITY && this.isTop(fact) && fact.nextSetBit(0) < this.topBit) {
            throw new IllegalStateException();
        }
    }

    @Override
    public String factToString(BitSet fact) {
        if (this.isTop(fact)) {
            return "[TOP]";
        }
        StringBuilder buf = new StringBuilder("[ ");
        boolean empty = true;
        for (int i = 0; i < this.killedByStoreOffset; ++i) {
            boolean killedByStore = this.killedByStore(fact, i);
            boolean storeAlive = this.isStoreAlive(fact, i);
            if (!storeAlive && !killedByStore) continue;
            if (!empty) {
                buf.append(", ");
            }
            empty = false;
            buf.append(i);
            if (storeAlive) {
                buf.append("L");
            }
            if (!killedByStore) continue;
            buf.append("k");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public boolean isTop(BitSet fact) {
        return fact.get(this.topBit);
    }

    public boolean isStoreAlive(BitSet fact, int local) {
        return fact.get(local);
    }

    public boolean killedByStore(BitSet fact, int local) {
        return fact.get(local + this.killedByStoreOffset);
    }
}

