/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.CommandLineUiCallback;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.IGuiCallback;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.SAXBugCollectionHandler;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.ba.URLClassPath;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.io.IO;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.xml.OutputStreamXMLOutput;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLOutputUtil;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Project
implements XMLWriteable,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(Project.class);
    private final List<File> currentWorkingDirectoryList;
    private String projectName;
    private List<String> analysisTargets;
    private List<String> srcDirList;
    private List<String> auxClasspathEntryList;
    private boolean isModified = false;
    private UserPreferences configuration;
    private final Map<String, Boolean> enabledPlugins;
    public static final String UNNAMED_PROJECT = "<<unnamed project>>";
    private long timestampForAnalyzedClasses = 0L;
    private IGuiCallback guiCallback;
    @Nonnull
    private Filter suppressionFilter = new Filter();
    private SourceFinder sourceFinder;
    static final String JAR_ELEMENT_NAME = "Jar";
    static final String AUX_CLASSPATH_ENTRY_ELEMENT_NAME = "AuxClasspathEntry";
    static final String SRC_DIR_ELEMENT_NAME = "SrcDir";
    static final String WRK_DIR_ELEMENT_NAME = "WrkDir";
    static final String FILENAME_ATTRIBUTE_NAME = "filename";
    static final String PROJECTNAME_ATTRIBUTE_NAME = "projectName";
    static final String PLUGIN_ELEMENT_NAME = "Plugin";
    static final String PLUGIN_ID_ATTRIBUTE_NAME = "id";
    static final String PLUGIN_STATUS_ELEMENT_NAME = "enabled";
    private static final String OPTIONS_KEY = "[Options]";
    private static final String JAR_FILES_KEY = "[Jar files]";
    private static final String SRC_DIRS_KEY = "[Source dirs]";
    private static final String AUX_CLASSPATH_ENTRIES_KEY = "[Aux classpath entries]";
    public static final String RELATIVE_PATHS = "relative_paths";
    private static final boolean FILE_IGNORE_CASE = SystemProperties.getProperty("os.name", "unknown").startsWith("Windows");

    @CheckForNull
    public Boolean getPluginStatus(Plugin plugin) {
        return this.enabledPlugins.get(plugin.getPluginId());
    }

    public void setPluginStatusTrinary(String pluginId, Boolean enabled) {
        this.enabledPlugins.put(pluginId, enabled);
    }

    public UserPreferences getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(@Nonnull UserPreferences configuration) {
        Objects.requireNonNull(configuration);
        this.configuration = configuration;
    }

    public Project() {
        this.enabledPlugins = new HashMap<String, Boolean>();
        this.configuration = UserPreferences.createDefaultUserPreferences();
        this.analysisTargets = new LinkedList<String>();
        this.srcDirList = new LinkedList<String>();
        this.auxClasspathEntryList = new LinkedList<String>();
        this.currentWorkingDirectoryList = new ArrayList<File>();
    }

    public Project duplicate() {
        Project dup = new Project();
        dup.currentWorkingDirectoryList.addAll(this.currentWorkingDirectoryList);
        dup.projectName = this.projectName;
        dup.analysisTargets.addAll(this.analysisTargets);
        dup.srcDirList.addAll(this.srcDirList);
        dup.auxClasspathEntryList.addAll(this.auxClasspathEntryList);
        dup.timestampForAnalyzedClasses = this.timestampForAnalyzedClasses;
        dup.guiCallback = this.guiCallback;
        return dup;
    }

    public SourceFinder getSourceFinder() {
        if (this.sourceFinder == null) {
            this.sourceFinder = new SourceFinder(this);
        }
        return this.sourceFinder;
    }

    public boolean isGuiAvaliable() {
        return this.guiCallback != null;
    }

    public void add(Project project2) {
        this.analysisTargets = Project.appendWithoutDuplicates(this.analysisTargets, project2.analysisTargets);
        this.srcDirList = Project.appendWithoutDuplicates(this.srcDirList, project2.srcDirList);
        this.auxClasspathEntryList = Project.appendWithoutDuplicates(this.auxClasspathEntryList, project2.auxClasspathEntryList);
    }

    public static <T> List<T> appendWithoutDuplicates(List<T> lst1, List<T> lst2) {
        LinkedHashSet<T> joined = new LinkedHashSet<T>(lst1);
        joined.addAll(lst2);
        return new ArrayList<T>(joined);
    }

    public void setCurrentWorkingDirectory(File f) {
        if (f != null) {
            this.addWorkingDir(f.toString());
        }
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean isModified) {
        this.isModified = isModified;
    }

    public boolean addFile(String fileName) {
        return this.addToListInternal(this.analysisTargets, this.makeAbsoluteCWD(fileName));
    }

    @Deprecated
    public boolean addSourceDir(String sourceDir) {
        return this.addSourceDirs(Collections.singletonList(sourceDir));
    }

    public boolean addSourceDirs(Collection<String> sourceDirs) {
        boolean isNew = false;
        if (sourceDirs == null || sourceDirs.isEmpty()) {
            return isNew;
        }
        for (String dirName : sourceDirs) {
            for (String dir : this.makeAbsoluteCwdCandidates(dirName)) {
                isNew = this.addToListInternal(this.srcDirList, dir) || isNew;
            }
        }
        IO.close(this.sourceFinder);
        this.sourceFinder = new SourceFinder(this);
        return isNew;
    }

    public boolean addWorkingDir(String dirName) {
        if (dirName == null) {
            throw new NullPointerException();
        }
        return this.addToListInternal(this.currentWorkingDirectoryList, new File(dirName));
    }

    public int getFileCount() {
        return this.analysisTargets.size();
    }

    public String getFile(int num) {
        return this.analysisTargets.get(num);
    }

    public void removeFile(int num) {
        this.analysisTargets.remove(num);
        this.isModified = true;
    }

    public List<String> getFileList() {
        return this.analysisTargets;
    }

    public int getNumSourceDirs() {
        return this.srcDirList.size();
    }

    public String getSourceDir(int num) {
        return this.srcDirList.get(num);
    }

    public void removeSourceDir(int num) {
        this.srcDirList.remove(num);
        IO.close(this.sourceFinder);
        this.sourceFinder = new SourceFinder(this);
        this.isModified = true;
    }

    public String[] getFileArray() {
        return this.analysisTargets.toArray(new String[0]);
    }

    public String[] getSourceDirArray() {
        return this.srcDirList.toArray(new String[0]);
    }

    public List<String> getSourceDirList() {
        return this.srcDirList;
    }

    public boolean addAuxClasspathEntry(String auxClasspathEntry) {
        return this.addToListInternal(this.auxClasspathEntryList, this.makeAbsoluteCWD(auxClasspathEntry));
    }

    public int getNumAuxClasspathEntries() {
        return this.auxClasspathEntryList.size();
    }

    public String getAuxClasspathEntry(int n) {
        return this.auxClasspathEntryList.get(n);
    }

    public void removeAuxClasspathEntry(int n) {
        this.auxClasspathEntryList.remove(n);
        this.isModified = true;
    }

    public List<String> getAuxClasspathEntryList() {
        return this.auxClasspathEntryList;
    }

    @Deprecated
    public List<String> getImplicitClasspathEntryList() {
        LinkedList<String> implicitClasspath = new LinkedList<String>();
        WorkList workList = new WorkList();
        for (String fileName : this.analysisTargets) {
            try {
                URL url = workList.createURL(fileName);
                WorkListItem item = new WorkListItem(url);
                workList.add(item);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        while (!workList.isEmpty()) {
            WorkListItem item = workList.getNextItem();
            this.processComponentJar(item.getURL(), workList, implicitClasspath);
        }
        return implicitClasspath;
    }

    private void processComponentJar(URL jarFileURL, WorkList workList, List<String> implicitClasspath) {
        LOG.debug("Processing {}", (Object)jarFileURL);
        if (!jarFileURL.toString().endsWith(".zip") && !jarFileURL.toString().endsWith(".jar")) {
            return;
        }
        try {
            URL manifestURL = new URL("jar:" + jarFileURL.toString() + "!/META-INF/MANIFEST.MF");
            try (InputStream in = manifestURL.openStream();){
                Manifest manifest = new Manifest(in);
                Attributes mainAttrs = manifest.getMainAttributes();
                String classPath = mainAttrs.getValue("Class-Path");
                if (classPath != null) {
                    String[] fileList;
                    for (String jarFile : fileList = classPath.split("\\s+")) {
                        URL referencedURL = workList.createRelativeURL(jarFileURL, jarFile);
                        if (!workList.add(new WorkListItem(referencedURL))) continue;
                        implicitClasspath.add(referencedURL.toString());
                        LOG.debug("Implicit jar: {}", (Object)referencedURL);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public void write(String outputFile, boolean useRelativePaths, String relativeBase) throws IOException {
        try (PrintWriter writer = UTF8.printWriter(outputFile);){
            writer.println(JAR_FILES_KEY);
            for (String jarFile : this.analysisTargets) {
                if (useRelativePaths) {
                    jarFile = this.convertToRelative(jarFile, relativeBase);
                }
                writer.println(jarFile);
            }
            writer.println(SRC_DIRS_KEY);
            for (String srcDir : this.srcDirList) {
                if (useRelativePaths) {
                    srcDir = this.convertToRelative(srcDir, relativeBase);
                }
                writer.println(srcDir);
            }
            writer.println(AUX_CLASSPATH_ENTRIES_KEY);
            for (String auxClasspathEntry : this.auxClasspathEntryList) {
                if (useRelativePaths) {
                    auxClasspathEntry = this.convertToRelative(auxClasspathEntry, relativeBase);
                }
                writer.println(auxClasspathEntry);
            }
            if (useRelativePaths) {
                writer.println(OPTIONS_KEY);
                writer.println("relative_paths=true");
            }
        }
        this.isModified = false;
    }

    public static Project readXML(File f) throws IOException, SAXException, ParserConfigurationException {
        Project project = new Project();
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(f.toPath(), new OpenOption[0]));){
            SAXBugCollectionHandler handler;
            String tag = Util.getXMLType(in);
            if ("Project".equals(tag)) {
                handler = new SAXBugCollectionHandler(project, f);
            } else if ("BugCollection".equals(tag)) {
                SortedBugCollection bugs = new SortedBugCollection(project);
                handler = new SAXBugCollectionHandler(bugs, f);
            } else {
                throw new IOException("Can't load a project from a " + tag + " file");
            }
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            parserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
            parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
            parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
            parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader xr = parser.getXMLReader();
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            try (Reader reader = Util.getReader(in);){
                xr.parse(new InputSource(reader));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            project.close();
            throw e;
        }
        project.setModified(false);
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeXML(File f, @CheckForNull BugCollection bugCollection) throws IOException {
        OutputStream out = Files.newOutputStream(f.toPath(), new OpenOption[0]);
        OutputStreamXMLOutput xmlOutput = new OutputStreamXMLOutput(out);
        try {
            this.writeXML(xmlOutput, f, bugCollection);
        }
        finally {
            xmlOutput.finish();
        }
    }

    public static Project readProject(String argument) throws IOException {
        String projectFileName = argument;
        File projectFile = new File(projectFileName);
        if (projectFileName.endsWith(".xml") || projectFileName.endsWith(".fbp")) {
            try {
                return Project.readXML(projectFile);
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new IOException("Couldn't read saved FindBugs project", e);
            }
        }
        throw new IllegalArgumentException("Can't read project from " + argument);
    }

    public String toString() {
        if (this.projectName != null) {
            return this.projectName;
        }
        return UNNAMED_PROJECT;
    }

    public static String transformFilename(String fileName) {
        if (!((String)fileName).endsWith(".fb")) {
            fileName = (String)fileName + ".fb";
        }
        return fileName;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, null, null);
    }

    public void writeXML(XMLOutput xmlOutput, @CheckForNull File destination, @CheckForNull BugCollection bugCollection) throws IOException {
        XMLAttributeList attributeList = new XMLAttributeList();
        if (this.getProjectName() != null) {
            attributeList = attributeList.addAttribute(PROJECTNAME_ATTRIBUTE_NAME, this.getProjectName());
        }
        xmlOutput.openTag("Project", attributeList);
        if (destination != null) {
            String base = destination.getParent();
            XMLOutputUtil.writeElementList(xmlOutput, JAR_ELEMENT_NAME, this.convertToRelative(this.analysisTargets, base));
            XMLOutputUtil.writeElementList(xmlOutput, AUX_CLASSPATH_ENTRY_ELEMENT_NAME, this.convertToRelative(this.auxClasspathEntryList, base));
            XMLOutputUtil.writeElementList(xmlOutput, SRC_DIR_ELEMENT_NAME, this.convertToRelative(this.srcDirList, base));
            ArrayList<String> cwdStrings = new ArrayList<String>();
            for (File file : this.currentWorkingDirectoryList) {
                cwdStrings.add(file.getPath());
            }
            XMLOutputUtil.writeElementList(xmlOutput, WRK_DIR_ELEMENT_NAME, this.convertToRelative(cwdStrings, base));
        } else {
            XMLOutputUtil.writeElementList(xmlOutput, JAR_ELEMENT_NAME, this.analysisTargets);
            XMLOutputUtil.writeElementList(xmlOutput, AUX_CLASSPATH_ENTRY_ELEMENT_NAME, this.auxClasspathEntryList);
            XMLOutputUtil.writeElementList(xmlOutput, SRC_DIR_ELEMENT_NAME, this.srcDirList);
            XMLOutputUtil.writeFileList(xmlOutput, WRK_DIR_ELEMENT_NAME, this.currentWorkingDirectoryList);
        }
        if (!this.suppressionFilter.isEmpty()) {
            xmlOutput.openTag("SuppressionFilter");
            this.suppressionFilter.writeBodyAsXML(xmlOutput);
            xmlOutput.closeTag("SuppressionFilter");
        }
        for (Map.Entry<String, Boolean> e : this.enabledPlugins.entrySet()) {
            String pluginId = e.getKey();
            Boolean enabled = e.getValue();
            Plugin plugin = Plugin.getByPluginId(pluginId);
            if (plugin == null || enabled == null) continue;
            XMLAttributeList pluginAttributeList = new XMLAttributeList();
            pluginAttributeList.addAttribute(PLUGIN_ID_ATTRIBUTE_NAME, plugin.getPluginId());
            pluginAttributeList.addAttribute(PLUGIN_STATUS_ELEMENT_NAME, enabled.toString());
            xmlOutput.openCloseTag(PLUGIN_ELEMENT_NAME, pluginAttributeList);
        }
        xmlOutput.closeTag("Project");
    }

    private Iterable<String> convertToRelative(List<String> paths, String base) {
        ArrayList<String> newList = new ArrayList<String>(paths.size());
        for (String path : paths) {
            newList.add(this.convertToRelative(path, base));
        }
        return newList;
    }

    private String convertToRelative(String srcFile, String base) {
        String subPath;
        String root;
        String slash = SystemProperties.getProperty("file.separator");
        if (FILE_IGNORE_CASE) {
            srcFile = srcFile.toLowerCase();
            base = ((String)base).toLowerCase();
        }
        if (((String)base).equals(srcFile)) {
            return ".";
        }
        if (!((String)base).endsWith(slash)) {
            base = (String)base + slash;
        }
        if (((String)base).length() <= srcFile.length() && (root = srcFile.substring(0, ((String)base).length())).equals(base)) {
            return "." + SystemProperties.getProperty("file.separator") + srcFile.substring(((String)base).length());
        }
        int slashPos = srcFile.indexOf(slash);
        if (slashPos >= 0 && ((subPath = srcFile.substring(0, slashPos)).isEmpty() || ((String)base).startsWith(subPath))) {
            int branchPoint = slashPos + 1;
            slashPos = srcFile.indexOf(slash, branchPoint);
            while (slashPos >= 0 && ((String)base).startsWith(subPath = srcFile.substring(0, slashPos))) {
                branchPoint = slashPos + 1;
                slashPos = srcFile.indexOf(slash, branchPoint);
            }
            int slashCount = 0;
            slashPos = ((String)base).indexOf(slash, branchPoint);
            while (slashPos >= 0) {
                ++slashCount;
                slashPos = ((String)base).indexOf(slash, slashPos + 1);
            }
            StringBuilder path = new StringBuilder();
            String upDir = ".." + slash;
            for (int i = 0; i < slashCount; ++i) {
                path.append(upDir);
            }
            path.append(srcFile.substring(branchPoint));
            return path.toString();
        }
        return srcFile;
    }

    private String makeAbsoluteCWD(String fileName) {
        List<String> candidates = this.makeAbsoluteCwdCandidates(fileName);
        return candidates.get(0);
    }

    private List<String> makeAbsoluteCwdCandidates(String fileName) {
        boolean hasProtocol;
        ArrayList<String> candidates = new ArrayList<String>();
        boolean bl = hasProtocol = URLClassPath.getURLProtocol(fileName) != null;
        if (hasProtocol) {
            candidates.add(fileName);
            return candidates;
        }
        if (new File(fileName).isAbsolute()) {
            candidates.add(fileName);
            return candidates;
        }
        for (File currentWorkingDirectory : this.currentWorkingDirectoryList) {
            File relativeToCurrent = new File(currentWorkingDirectory, fileName);
            if (!relativeToCurrent.exists()) continue;
            candidates.add(relativeToCurrent.toString());
        }
        if (candidates.isEmpty()) {
            candidates.add(fileName);
        }
        return candidates;
    }

    private <T> boolean addToListInternal(Collection<T> list, T value) {
        if (!list.contains(value)) {
            list.add(value);
            this.isModified = true;
            return true;
        }
        return false;
    }

    public void setTimestamp(long timestamp) {
        this.timestampForAnalyzedClasses = timestamp;
    }

    public void addTimestamp(long timestamp) {
        if (this.timestampForAnalyzedClasses < timestamp && FindBugs.validTimestamp(timestamp)) {
            this.timestampForAnalyzedClasses = timestamp;
        }
    }

    public long getTimestamp() {
        return this.timestampForAnalyzedClasses;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setSuppressionFilter(@Nonnull Filter suppressionFilter) {
        Objects.requireNonNull(suppressionFilter);
        this.suppressionFilter = suppressionFilter;
    }

    @Nonnull
    public Filter getSuppressionFilter() {
        return this.suppressionFilter;
    }

    public void setGuiCallback(IGuiCallback guiCallback) {
        this.guiCallback = guiCallback;
    }

    public IGuiCallback getGuiCallback() {
        if (this.guiCallback == null) {
            this.guiCallback = new CommandLineUiCallback();
        }
        return this.guiCallback;
    }

    public Iterable<String> getResolvedSourcePaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.srcDirList) {
            boolean hasProtocol;
            boolean bl = hasProtocol = URLClassPath.getURLProtocol(s) != null;
            if (hasProtocol) {
                result.add(s);
                continue;
            }
            File f = new File(s);
            if (f.isAbsolute() || this.currentWorkingDirectoryList.isEmpty()) {
                if (!f.canRead()) continue;
                result.add(s);
                continue;
            }
            for (File d : this.currentWorkingDirectoryList) {
                File a;
                if (!d.canRead() || !d.isDirectory() || !(a = new File(d, s)).canRead()) continue;
                result.add(a.getAbsolutePath());
            }
        }
        return result;
    }

    @Override
    public void close() {
        IO.close(this.sourceFinder);
    }

    private static class WorkList {
        private static final Logger LOG = LoggerFactory.getLogger(WorkList.class);
        private final LinkedList<WorkListItem> itemList = new LinkedList();
        private final HashSet<String> addedSet = new HashSet();

        public URL createURL(String fileName) throws MalformedURLException {
            String protocol = URLClassPath.getURLProtocol((String)fileName);
            if (protocol == null) {
                fileName = "file:" + (String)fileName;
            }
            return new URL((String)fileName);
        }

        public URL createRelativeURL(URL base, String fileName) throws MalformedURLException {
            return new URL(base, fileName);
        }

        public boolean add(WorkListItem item) {
            LOG.debug("Adding {}", (Object)item.getURL());
            if (!this.addedSet.add(item.getURL().toString())) {
                LOG.debug("\t==> Already processed");
                return false;
            }
            this.itemList.add(item);
            return true;
        }

        public boolean isEmpty() {
            return this.itemList.isEmpty();
        }

        public WorkListItem getNextItem() {
            return this.itemList.removeFirst();
        }
    }

    private static class WorkListItem {
        private final URL url;

        public WorkListItem(URL url) {
            this.url = url;
        }

        public URL getURL() {
            return this.url;
        }
    }
}

