/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import java.util.regex.Pattern;

class PriorityAdjustment {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");
    private final int adjustmentValue;
    private final boolean isDelta;

    PriorityAdjustment(String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Priority adjustment value cannot be null or empty");
        }
        if (value.startsWith("+")) {
            String num = value.substring(1);
            if (!NUMBER_PATTERN.matcher(num).matches()) {
                throw PriorityAdjustment.wrongFormat(value);
            }
            this.isDelta = true;
            this.adjustmentValue = Integer.parseInt(num);
        } else if (value.startsWith("-")) {
            String num = value.substring(1);
            if (!NUMBER_PATTERN.matcher(num).matches()) {
                throw PriorityAdjustment.wrongFormat(value);
            }
            this.isDelta = true;
            this.adjustmentValue = -Integer.parseInt(num);
        } else if (NUMBER_PATTERN.matcher(value).matches()) {
            this.isDelta = false;
            this.adjustmentValue = Integer.parseInt(value);
        } else if ("raise".equals(value)) {
            this.isDelta = true;
            this.adjustmentValue = -1;
        } else if ("lower".equals(value)) {
            this.isDelta = true;
            this.adjustmentValue = 1;
        } else if ("suppress".equals(value)) {
            this.isDelta = true;
            this.adjustmentValue = 100;
        } else {
            throw PriorityAdjustment.wrongFormat(value);
        }
    }

    private static IllegalArgumentException wrongFormat(String value) {
        return new IllegalArgumentException("Invalid priority adjustment value: " + value + ". Must be +[integer], -[integer], [integer] or one of raise|lower|suppress");
    }

    public int adjust(int priority) {
        return this.isDelta ? priority + this.adjustmentValue : this.adjustmentValue;
    }
}

