/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.HTMLBugReporter;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.TextUIBugReporter;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.util.Bag;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class PrintingBugReporter
extends TextUIBugReporter {
    private final HashSet<BugInstance> seenAlready = new HashSet();

    @Override
    public void observeClass(ClassDescriptor classDescriptor) {
    }

    @Override
    protected void doReportBug(BugInstance bugInstance) {
        if (this.seenAlready.add(bugInstance)) {
            this.printBug(bugInstance);
            this.notifyObservers(bugInstance);
        }
    }

    @Override
    public void finish() {
        this.outputStream.close();
    }

    public static void main(String[] args) throws Exception {
        FindBugs.setNoAnalysis();
        PrintingBugReporter reporter = new PrintingBugReporter();
        PrintingCommandLine commandLine = reporter.new PrintingCommandLine();
        int argCount = commandLine.parse(args, 0, 2, "Usage: " + PrintingCommandLine.class.getName() + " [options] [<xml results> [<test results>]] ");
        if (commandLine.stylesheet != null) {
            PrintingBugReporter.xslt(commandLine.stylesheet, reporter.isApplySuppressions(), args, argCount);
            return;
        }
        SortedBugCollection bugCollection = new SortedBugCollection(commandLine.getProject());
        if (argCount < args.length) {
            bugCollection.readXML(args[argCount++]);
        } else {
            bugCollection.readXML(System.in);
        }
        if (argCount < args.length) {
            reporter.setOutputStream(UTF8.printStream(Files.newOutputStream(Path.of(args[argCount++], new String[0]), new OpenOption[0]), true));
        }
        boolean bugsReported = false;
        RuntimeException storedException = null;
        Bag lowRank = new Bag(new TreeMap());
        for (BugInstance bugInstance : bugCollection.getCollection()) {
            if (reporter.isApplySuppressions() && bugCollection.getProject().getSuppressionFilter().match(bugInstance)) continue;
            int rank = bugInstance.getBugRank();
            BugPattern pattern = bugInstance.getBugPattern();
            if (rank <= commandLine.maxRank) {
                bugsReported = true;
                try {
                    reporter.printBug(bugInstance);
                }
                catch (RuntimeException e) {
                    if (storedException != null) continue;
                    storedException = e;
                }
                continue;
            }
            if (rank > commandLine.summarizeMaxRank) continue;
            bugsReported = true;
            lowRank.add(pattern.getCategory());
        }
        reporter.finish();
        for (Map.Entry entry : lowRank.entrySet()) {
            System.out.printf("%4d low ranked %s issues%n", entry.getValue(), I18N.instance().getBugCategoryDescription((String)entry.getKey()));
        }
        if (commandLine.setExitCode) {
            int exitCode = 0;
            System.err.println("Calculating exit code...");
            if (storedException != null) {
                exitCode |= 4;
                System.err.println("Setting 'errors encountered' flag (4)");
                storedException.printStackTrace(System.err);
            }
            if (bugsReported) {
                exitCode |= 1;
                System.err.println("Setting 'bugs found' flag (1)");
            }
            System.err.println("Exit code set to: " + exitCode);
            System.exit(exitCode);
        } else if (storedException != null) {
            throw storedException;
        }
    }

    public static void xslt(String stylesheet, boolean applySuppression, String[] args, int argCount) throws Exception {
        Project proj = new Project();
        HTMLBugReporter reporter = new HTMLBugReporter(proj, stylesheet);
        BugCollection bugCollection = reporter.getBugCollection();
        bugCollection.setApplySuppressions(applySuppression);
        if (argCount < args.length) {
            bugCollection.readXML(args[argCount++]);
        } else {
            bugCollection.readXML(System.in);
        }
        if (argCount < args.length) {
            reporter.setOutputStream(UTF8.printStream(Files.newOutputStream(Path.of(args[argCount++], new String[0]), new OpenOption[0]), true));
        }
        reporter.finish();
        Exception e = reporter.getFatalException();
        if (e != null) {
            throw e;
        }
    }

    @Override
    @CheckForNull
    public BugCollection getBugCollection() {
        return null;
    }

    class PrintingCommandLine
    extends CommandLine {
        private String stylesheet = null;
        private int maxRank;
        private int summarizeMaxRank = this.maxRank = 20;
        private final Project project = new Project();
        private boolean setExitCode;

        public PrintingCommandLine() {
            this.addSwitch("-longBugCodes", "use long bug codes when generating text");
            this.addSwitch("-rank", "list rank when generating text");
            this.addOption("-maxRank", "max rank", "only list bugs of this rank or less");
            this.addOption("-summarizeMaxRank", "max rank", "summary bugs with of this rank or less");
            this.addSwitch("-history", "report first and last versions for each bug");
            this.addSwitch("-applySuppression", "exclude any bugs that match suppression filters");
            this.addSwitchWithOptionalExtraPart("-html", "stylesheet", "Generate HTML output (default stylesheet is default.xsl)");
            this.addOption("-pluginList", "jar1[" + File.pathSeparator + "jar2...]", "specify list of plugin Jar files to load");
            this.addSwitch("-exitcode", "set exit code of process");
        }

        @Nonnull
        public Project getProject() {
            return this.project;
        }

        @Override
        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if ("-longBugCodes".equals(option)) {
                PrintingBugReporter.this.setUseLongBugCodes(true);
            } else if ("-rank".equals(option)) {
                PrintingBugReporter.this.setShowRank(true);
            } else if ("-applySuppression".equals(option)) {
                PrintingBugReporter.this.setApplySuppressions(true);
            } else if ("-history".equals(option)) {
                PrintingBugReporter.this.setReportHistory(true);
            } else if ("-html".equals(option)) {
                this.stylesheet = !"".equals(optionExtraPart) ? optionExtraPart : "default.xsl";
            } else if ("-exitcode".equals(option)) {
                this.setExitCode = true;
            } else {
                throw new IllegalArgumentException("Unknown option '" + option + "'");
            }
        }

        @Override
        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if ("-pluginList".equals(option)) {
                String pluginListStr = argument;
                Map<String, Boolean> customPlugins = this.getProject().getConfiguration().getCustomPlugins();
                StringTokenizer tok = new StringTokenizer(pluginListStr, File.pathSeparator);
                while (tok.hasMoreTokens()) {
                    File file = new File(tok.nextToken());
                    Boolean enabled = file.isFile();
                    customPlugins.put(file.getAbsolutePath(), enabled);
                    if (!enabled.booleanValue()) continue;
                    try {
                        Plugin.loadCustomPlugin(file, this.getProject());
                    }
                    catch (PluginException e) {
                        throw new IllegalStateException("Failed to load plugin specified by the '-pluginList', file: " + String.valueOf(file), e);
                    }
                }
            } else if ("-maxRank".equals(option)) {
                this.maxRank = Integer.parseInt(argument);
            } else if ("-summarizeMaxRank".equals(option)) {
                this.summarizeMaxRank = Integer.parseInt(argument);
            } else {
                throw new IllegalStateException();
            }
        }
    }
}

