/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationWithSourceLines;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugsDisplayFeatures;
import edu.umd.cs.findbugs.FindBugsMessageFormat;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.ArrayList;
import java.util.List;

public abstract class PackageMemberAnnotation
extends BugAnnotationWithSourceLines {
    private static final long serialVersionUID = -8208567669352996892L;
    @DottedClassName
    protected final String className;
    protected String description;
    private List<String> javaAnnotationNames = new ArrayList<String>();

    protected PackageMemberAnnotation(@DottedClassName String className, String description) {
        this(className, description, PackageMemberAnnotation.computeSourceFile(className));
    }

    private static String computeSourceFile(String className) {
        AnalysisContext context = AnalysisContext.currentAnalysisContext();
        if (context != null) {
            return context.lookupSourceFile(className);
        }
        return "<Unknown>";
    }

    protected PackageMemberAnnotation(@DottedClassName String className, String description, String sourceFileName) {
        if (className.isEmpty()) {
            throw new IllegalArgumentException("Empty classname not allowed");
        }
        if (className.indexOf(47) >= 0) {
            assert (false) : "classname " + className + " should be dotted";
            className = ClassName.toDottedClassName(className);
        }
        this.className = className;
        this.sourceFileName = sourceFileName;
        if (description != null) {
            description = description.intern();
        }
        this.description = description;
    }

    @DottedClassName
    public final String getClassName() {
        return this.className;
    }

    @SlashedClassName
    public final String getSlashedClassName() {
        return ClassName.toSlashedClassName(this.className);
    }

    public String getSimpleClassName() {
        return ClassName.extractSimpleName(this.className);
    }

    public final ClassDescriptor getClassDescriptor() {
        return DescriptorFactory.instance().getClassDescriptorForDottedClassName(this.className);
    }

    @DottedClassName
    public final String getPackageName() {
        int lastDot = this.className.lastIndexOf(46);
        if (lastDot < 0) {
            return "";
        }
        return this.className.substring(0, lastDot);
    }

    @Override
    public final String format(String key, ClassAnnotation primaryClass) {
        if ("class.givenClass".equals(key)) {
            return PackageMemberAnnotation.shorten(primaryClass.getPackageName(), this.className);
        }
        if ("simpleClass".equals(key)) {
            return ClassName.extractSimpleName(this.className);
        }
        if ("class".equals(key)) {
            return this.className;
        }
        if ("package".equals(key)) {
            return this.getPackageName();
        }
        if ("".equals(key) && FindBugsDisplayFeatures.isAbridgedMessages() && primaryClass != null) {
            return this.formatPackageMember("givenClass", primaryClass);
        }
        return this.formatPackageMember(key, primaryClass);
    }

    @Override
    public void setDescription(String description) {
        this.description = description.intern();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public List<String> getJavaAnnotationNames() {
        return this.javaAnnotationNames;
    }

    public void setJavaAnnotationNames(List<String> aJavaAnnotationNames) {
        this.javaAnnotationNames = aJavaAnnotationNames;
    }

    protected static String shorten(String pkgName, String typeName) {
        String otherPkg;
        int index = typeName.lastIndexOf(46);
        if (index >= 0 && ((otherPkg = typeName.substring(0, index)).equals(pkgName) || "java.lang".equals(otherPkg))) {
            typeName = typeName.substring(index + 1);
        }
        return typeName;
    }

    protected static String removePackage(String typeName) {
        int index = typeName.lastIndexOf(46);
        if (index >= 0) {
            return typeName.substring(index + 1);
        }
        return typeName;
    }

    protected static String removePackageName(String typeName) {
        int index = typeName.lastIndexOf(46);
        if (index >= 0) {
            typeName = typeName.substring(index + 1);
        }
        return typeName;
    }

    protected abstract String formatPackageMember(String var1, ClassAnnotation var2);

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(ClassAnnotation primaryClass) {
        String pattern = I18N.instance().getAnnotationDescription(this.description);
        FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
        return format.format(new BugAnnotation[]{this}, primaryClass);
    }

    @Override
    public boolean isSignificant() {
        return true;
    }
}

