/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DelegatingBugReporter;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import java.util.HashSet;
import java.util.Set;

public class ErrorCountingBugReporter
extends DelegatingBugReporter {
    private int bugCount = 0;
    private final HashSet<String> errors = new HashSet();
    private final Set<String> missingClassSet = new HashSet<String>();

    public ErrorCountingBugReporter(BugReporter realBugReporter) {
        super(realBugReporter);
        realBugReporter.addObserver(bugInstance -> ++this.bugCount);
    }

    public int getBugCount() {
        return this.bugCount;
    }

    public int getMissingClassCount() {
        return this.missingClassSet.size();
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    @Override
    public void logError(String message) {
        if (this.errors.add(message)) {
            super.logError(message);
        }
    }

    @Override
    public void reportMissingClass(ClassNotFoundException ex) {
        String missing = AbstractBugReporter.getMissingClassName(ex);
        if (missing == null || missing.startsWith("[") || "java.lang.Synthetic".equals(missing)) {
            return;
        }
        if (this.missingClassSet.add(missing)) {
            super.reportMissingClass(ex);
        }
    }

    @Override
    public void reportMissingClass(ClassDescriptor classDescriptor) {
        String missing = classDescriptor.getDottedClassName();
        if (!AbstractBugReporter.isValidMissingClassMessage(missing)) {
            return;
        }
        if (this.missingClassSet.add(missing)) {
            super.reportMissingClass(classDescriptor);
        }
    }
}

