/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PropertyBundle;
import java.util.Set;

public class ComponentPlugin<T> {
    protected final Plugin plugin;
    protected final String id;
    protected final String shortId;
    protected final ClassLoader classLoader;
    protected final PropertyBundle properties;
    protected final String description;
    protected final String details;
    protected final boolean enabledByDefault;
    final Class<? extends T> componentClass;

    public ComponentPlugin(Plugin plugin, String id, ClassLoader classLoader, Class<? extends T> componentClass, PropertyBundle properties, boolean enabledByDefault, String description, String details) {
        this.plugin = plugin;
        this.id = id;
        int i = id.lastIndexOf(46);
        this.shortId = id.substring(i + 1);
        this.classLoader = classLoader;
        this.componentClass = componentClass;
        this.properties = properties;
        this.enabledByDefault = enabledByDefault;
        this.description = description;
        this.details = details;
    }

    public String getId() {
        return this.id;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public PropertyBundle getProperties() {
        return this.properties;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDetails() {
        return this.details;
    }

    public String toString() {
        return this.getDescription();
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public boolean isNamed(Set<String> names) {
        return names.contains(this.id) || names.contains(this.shortId);
    }

    public Class<? extends T> getComponentClass() {
        if (!this.isAvailable()) {
            if (FindBugs.isNoAnalysis()) {
                throw new IllegalStateException("No analysis set; no component class loaded for " + String.valueOf(this.getPlugin()));
            }
            throw new IllegalStateException("No component class for " + String.valueOf(this.getPlugin()));
        }
        return this.componentClass;
    }

    public boolean isAvailable() {
        return this.componentClass != null;
    }
}

