/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.IClassScreener;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassScreener
implements IClassScreener {
    private static final Logger LOG = LoggerFactory.getLogger(ClassScreener.class);
    private static final String SEP = "[/\\\\]";
    private static final String START = "(?:^|[/\\\\])";
    private static final String JAVA_IDENTIFIER_PART = "[^./\\\\]";
    private final LinkedList<Matcher> includePatternList = new LinkedList();
    private final LinkedList<Matcher> excludePatternList = new LinkedList();

    private static String dotsToRegex(String dotsName) {
        String tmp = dotsName.replace("$", "\\$");
        return tmp.replace(".", SEP);
    }

    public void addAllowedClass(String className) {
        LOG.debug("Allowed class: {}", (Object)className);
        if (className.startsWith("!")) {
            this.excludePatternList.add(ClassScreener.classMatcher(className.substring(1)));
        } else {
            this.includePatternList.add(ClassScreener.classMatcher(className));
        }
    }

    private static Matcher classMatcher(String className) {
        String classRegex = START + ClassScreener.dotsToRegex(className) + ".class$";
        LOG.debug("Class regex: {}", (Object)classRegex);
        return Pattern.compile(classRegex).matcher("");
    }

    public void addAllowedPackage(String packageName) {
        if (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        LOG.debug("Allowed package: {}", (Object)packageName);
        if (packageName.startsWith("!")) {
            this.excludePatternList.add(ClassScreener.packageMatcher(packageName.substring(1)));
        } else {
            this.includePatternList.add(ClassScreener.packageMatcher(packageName));
        }
    }

    private static Matcher packageMatcher(String packageName) {
        String packageRegex = START + ClassScreener.dotsToRegex(packageName) + "[/\\\\][^./\\\\]+.class$";
        LOG.debug("Package regex: {}", (Object)packageRegex);
        return Pattern.compile(packageRegex).matcher("");
    }

    public void addAllowedPrefix(String prefix) {
        if (prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        LOG.debug("Allowed prefix: {}", (Object)prefix);
        if (prefix.startsWith("!")) {
            this.excludePatternList.add(ClassScreener.prefixMatcher(prefix.substring(1)));
        } else {
            this.includePatternList.add(ClassScreener.prefixMatcher(prefix));
        }
    }

    private static Matcher prefixMatcher(String prefix) {
        String packageRegex = START + ClassScreener.dotsToRegex(prefix) + SEP;
        LOG.debug("Prefix regex: {}", (Object)packageRegex);
        return Pattern.compile(packageRegex).matcher("");
    }

    @Override
    public boolean matches(String fileName) {
        if (!this.excludePatternList.isEmpty()) {
            LOG.debug("Matching negative: {}", (Object)fileName);
            for (Matcher matcher : this.excludePatternList) {
                matcher.reset(fileName);
                if (matcher.find()) {
                    LOG.debug("\\tTrying not [{}]: yes!", (Object)matcher.pattern());
                    return false;
                }
                LOG.debug("\\tTrying not [{}]: no", (Object)matcher.pattern());
            }
        }
        if (this.includePatternList.isEmpty()) {
            return true;
        }
        LOG.debug("Matching: {}", (Object)fileName);
        for (Matcher matcher : this.includePatternList) {
            matcher.reset(fileName);
            if (matcher.find()) {
                LOG.debug("\\tTrying [{}]: yes!", (Object)matcher.pattern());
                return true;
            }
            LOG.debug("\\tTrying [{}]: no", (Object)matcher.pattern());
        }
        return false;
    }

    @Override
    public boolean vacuous() {
        return this.includePatternList.isEmpty() && this.excludePatternList.isEmpty();
    }
}

