/*
 * Decompiled with CFR 0.152.
 */
package com.github.oowekyala.ooxml;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DomUtils {
    public static List<Element> children(Element element) {
        ArrayList<Node> nodes = new ArrayList<Node>(DomUtils.asList(element.getChildNodes()));
        nodes.removeIf(n -> !(n instanceof Element));
        return nodes;
    }

    public static List<Element> childrenNamed(Element element, String localName) {
        ArrayList<Node> nodes = new ArrayList<Node>(DomUtils.asList(element.getChildNodes()));
        nodes.removeIf(n -> !(n instanceof Element) || !n.getLocalName().equals(localName));
        return nodes;
    }

    public static Optional<String> getAttributeOpt(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return Optional.ofNullable(element.getAttribute(attributeName));
        }
        return Optional.empty();
    }

    public static List<Node> asList(final NodeList nodeList) {
        return new AbstractList<Node>(){

            @Override
            public Node get(int index) {
                return nodeList.item(index);
            }

            @Override
            public int size() {
                return nodeList.getLength();
            }
        };
    }

    public static List<Node> asList(final NamedNodeMap nodeList) {
        return new AbstractList<Node>(){

            @Override
            public Node get(int index) {
                return nodeList.item(index);
            }

            @Override
            public int size() {
                return nodeList.getLength();
            }
        };
    }

    public static Map<String, Node> toMap(NamedNodeMap nodeList) {
        HashMap<String, Node> map = new HashMap<String, Node>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            map.put(item.getNodeName(), item);
        }
        return map;
    }
}

