/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JTypeVisitable;
import net.sourceforge.pmd.lang.java.types.JWildcardType;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeConversion;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.TypingContext;
import net.sourceforge.pmd.lang.java.types.internal.InternalMethodTypeItf;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.Infer;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodCallSite;
import net.sourceforge.pmd.lang.java.types.internal.infer.OverloadSet;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ExprOps {
    private final Infer infer;
    private final TypeSystem ts;

    ExprOps(Infer infer) {
        this.infer = infer;
        this.ts = infer.getTypeSystem();
        assert (this.ts != null);
    }

    boolean isPotentiallyCompatible(JMethodSig m, ExprMirror e, JTypeMirror t) {
        if (e instanceof ExprMirror.BranchingMirror) {
            ExprMirror.BranchingMirror cond = (ExprMirror.BranchingMirror)e;
            return cond.branchesMatch(branch -> this.isPotentiallyCompatible(m, (ExprMirror)branch, t));
        }
        boolean isLambdaOrRef = e instanceof ExprMirror.FunctionalExprMirror;
        if (isLambdaOrRef) {
            if (t instanceof JTypeVar) {
                return m.getTypeParameters().contains(t);
            }
            if (TypeOps.isUnresolved(t)) {
                return true;
            }
            JMethodSig fun = TypeOps.findFunctionalInterfaceMethod(t);
            if (fun == null) {
                return false;
            }
            if (e instanceof ExprMirror.LambdaExprMirror) {
                ExprMirror.LambdaExprMirror lambda = (ExprMirror.LambdaExprMirror)e;
                if (fun.getArity() != lambda.getParamCount()) {
                    return false;
                }
                boolean expectsVoid = fun.getReturnType() == this.ts.NO_TYPE;
                return expectsVoid && lambda.isVoidCompatible() || lambda.isValueCompatible();
            }
            return true;
        }
        return true;
    }

    static boolean isPertinentToApplicability(ExprMirror arg, JMethodSig m, JTypeMirror formalType, ExprMirror.InvocationMirror invoc) {
        if (arg instanceof ExprMirror.LambdaExprMirror) {
            ExprMirror.LambdaExprMirror lambda = (ExprMirror.LambdaExprMirror)arg;
            if (!lambda.isExplicitlyTyped()) {
                return false;
            }
            for (ExprMirror it : lambda.getResultExpressions()) {
                if (ExprOps.isPertinentToApplicability(it, m, formalType, invoc)) continue;
                return false;
            }
            return !m.isGeneric() || !invoc.getExplicitTypeArguments().isEmpty() || !formalType.isTypeVariable();
        }
        if (arg instanceof ExprMirror.MethodRefMirror) {
            return ExprOps.getExactMethod((ExprMirror.MethodRefMirror)arg) != null && (!m.isGeneric() || !invoc.getExplicitTypeArguments().isEmpty() || !formalType.isTypeVariable());
        }
        if (arg instanceof ExprMirror.BranchingMirror) {
            ExprMirror.BranchingMirror cond = (ExprMirror.BranchingMirror)arg;
            return cond.branchesMatch(branch -> ExprOps.isPertinentToApplicability(branch, m, formalType, invoc));
        }
        return true;
    }

    public static @Nullable JMethodSig getExactMethod(ExprMirror.MethodRefMirror mref) {
        JMethodSig cached = mref.getCachedExactMethod();
        if (cached == null) {
            return null;
        }
        if (cached.getTypeSystem().UNRESOLVED_METHOD == cached) {
            cached = ExprOps.computeExactMethod(mref);
            mref.setCachedExactMethod(cached);
        }
        return cached;
    }

    private static @Nullable JMethodSig computeExactMethod(ExprMirror.MethodRefMirror mref) {
        List<JMethodSig> accessible;
        @Nullable JTypeMirror lhs = mref.getLhsIfType();
        if (mref.isConstructorRef()) {
            if (lhs == null) {
                return null;
            }
            if (lhs.isArray()) {
                if (lhs.isReifiable()) {
                    JTypeDeclSymbol symbol = lhs.getSymbol();
                    assert (symbol instanceof JClassSymbol && ((JClassSymbol)symbol).isArray()) : "Reifiable array should present a symbol! " + lhs;
                    return lhs.getConstructors().get(0);
                }
                return null;
            }
            if (lhs.isRaw() || !(lhs instanceof JClassType)) {
                return null;
            }
            accessible = TypeOps.filterAccessible(lhs.getConstructors(), mref.getEnclosingType().getSymbol());
        } else {
            JClassType enclosing = mref.getEnclosingType();
            accessible = mref.getTypeToSearch().streamMethods(TypeOps.accessibleMethodFilter(mref.getMethodName(), enclosing.getSymbol())).collect(OverloadSet.collectMostSpecific(enclosing));
        }
        if (accessible.size() == 1) {
            JTypeVisitable candidate = accessible.get(0);
            if (candidate.isVarargs() || candidate.isGeneric() && mref.getExplicitTypeArguments().isEmpty()) {
                return null;
            }
            candidate = candidate.subst((Function)Substitution.mapping(candidate.getTypeParameters(), mref.getExplicitTypeArguments()));
            if (lhs != null && lhs.isRaw()) {
                JClassType lhsClass = (JClassType)candidate.getDeclaringType();
                JMethodSig unerased = InternalMethodTypeItf.cast(InternalMethodTypeItf.cast((JMethodSig)candidate).withOwner(lhsClass.getGenericTypeDeclaration())).originalMethod();
                if (TypeOps.mentionsAny(unerased, lhsClass.getFormalTypeParams())) {
                    return null;
                }
            }
            return ExprOps.adaptGetClass((JMethodSig)candidate, mref::getTypeToSearch);
        }
        return null;
    }

    @Nullable ExprMirror.InvocationMirror.MethodCtDecl findInexactMethodRefCompileTimeDecl(ExprMirror.MethodRefMirror mref, JMethodSig targetType) {
        JTypeMirror lhsIfType = mref.getLhsIfType();
        boolean acceptLowerArity = lhsIfType != null && lhsIfType.isClassOrInterface() && !mref.isConstructorRef();
        MethodCallSite site1 = this.infer.newCallSite(ExprOps.methodRefAsInvocation(mref, targetType, false), null);
        site1.setLogging(!acceptLowerArity);
        ExprMirror.InvocationMirror.MethodCtDecl ctd1 = this.infer.determineInvocationTypeOrFail(site1);
        JMethodSig m1 = ctd1.getMethodType();
        if (acceptLowerArity) {
            MethodCallSite site2 = this.infer.newCallSite(ExprOps.methodRefAsInvocation(mref, targetType, true), null);
            site2.setLogging(false);
            ExprMirror.InvocationMirror.MethodCtDecl ctd2 = this.infer.determineInvocationTypeOrFail(site2);
            JMethodSig m2 = ctd2.getMethodType();
            if (m1 != this.ts.UNRESOLVED_METHOD && m1.isStatic() && (m2 == this.ts.UNRESOLVED_METHOD || m2.isStatic())) {
                return ctd1;
            }
            if (!(m2 == this.ts.UNRESOLVED_METHOD || m2.isStatic() || m1 != this.ts.UNRESOLVED_METHOD && m1.isStatic())) {
                return ctd2;
            }
            return null;
        }
        if (m1 == this.ts.UNRESOLVED_METHOD || m1.isStatic()) {
            return null;
        }
        return ctd1;
    }

    static ExprMirror.InvocationMirror methodRefAsInvocation(final ExprMirror.MethodRefMirror mref, final JMethodSig targetType, final boolean asInstanceMethod) {
        List<JTypeMirror> formals = targetType.getFormalParameters();
        if (asInstanceMethod && !formals.isEmpty()) {
            formals = formals.subList(1, formals.size());
        }
        final List arguments = CollectionUtil.map(formals, fi -> new ExprMirror(){
            final /* synthetic */ JTypeMirror val$fi;
            {
                this.val$fi = jTypeMirror;
            }

            @Override
            public void setInferredType(JTypeMirror mirror) {
            }

            @Override
            public @Nullable JTypeMirror getInferredType() {
                throw new UnsupportedOperationException();
            }

            @Override
            public JavaNode getLocation() {
                return mref.getLocation();
            }

            @Override
            public JTypeMirror getStandaloneType() {
                return this.val$fi;
            }

            public String toString() {
                return "formal : " + this.val$fi;
            }

            @Override
            public TypingContext getTypingContext() {
                return mref.getTypingContext();
            }

            @Override
            public boolean isEquivalentToUnderlyingAst() {
                throw new UnsupportedOperationException("Cannot invoque isSemanticallyEquivalent on this mirror, it doesn't have a backing AST node: " + this);
            }
        });
        return new ExprMirror.InvocationMirror(){
            private ExprMirror.InvocationMirror.MethodCtDecl mt;
            JTypeMirror inferred;

            @Override
            public JavaNode getLocation() {
                return mref.getLocation();
            }

            @Override
            public Iterable<JMethodSig> getAccessibleCandidates() {
                return ExprOps.getAccessibleCandidates(mref, asInstanceMethod, targetType);
            }

            @Override
            public JTypeMirror getErasedReceiverType() {
                return mref.getTypeToSearch().getErasure();
            }

            @Override
            public @Nullable JTypeMirror getReceiverType() {
                return mref.getTypeToSearch();
            }

            @Override
            public List<JTypeMirror> getExplicitTypeArguments() {
                return mref.getExplicitTypeArguments();
            }

            @Override
            public JavaNode getExplicitTargLoc(int i) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public String getName() {
                return mref.getMethodName();
            }

            @Override
            public List<ExprMirror> getArgumentExpressions() {
                return arguments;
            }

            @Override
            public int getArgumentCount() {
                return arguments.size();
            }

            @Override
            public void setCompileTimeDecl(ExprMirror.InvocationMirror.MethodCtDecl methodType) {
                this.mt = methodType;
            }

            @Override
            public @Nullable ExprMirror.InvocationMirror.MethodCtDecl getCtDecl() {
                return this.mt;
            }

            @Override
            public void setInferredType(JTypeMirror mirror) {
                this.inferred = mirror;
            }

            @Override
            public JTypeMirror getInferredType() {
                return this.inferred;
            }

            @Override
            public @NonNull JClassType getEnclosingType() {
                return mref.getEnclosingType();
            }

            public String toString() {
                return "Method ref adapter (for " + mref + ")";
            }

            @Override
            public TypingContext getTypingContext() {
                return mref.getTypingContext();
            }

            @Override
            public boolean isEquivalentToUnderlyingAst() {
                throw new UnsupportedOperationException("Cannot invoque isSemanticallyEquivalent on this mirror, it doesn't have a backing AST node: " + this);
            }
        };
    }

    private static Iterable<JMethodSig> getAccessibleCandidates(ExprMirror.MethodRefMirror mref, boolean asInstanceMethod, JMethodSig targetType) {
        JMethodSig exactMethod = ExprOps.getExactMethod(mref);
        if (exactMethod != null) {
            return Collections.singletonList(exactMethod);
        }
        JTypeMirror typeToSearch = mref.getTypeToSearch();
        if (typeToSearch.isArray() && mref.isConstructorRef()) {
            return typeToSearch.getConstructors();
        }
        if (typeToSearch instanceof JClassType && mref.isConstructorRef()) {
            return TypeOps.lazyFilterAccessible(typeToSearch.getConstructors(), mref.getEnclosingType().getSymbol());
        }
        if (asInstanceMethod && typeToSearch.isRaw() && typeToSearch instanceof JClassType && targetType.getArity() > 0) {
            JClassType type = (JClassType)typeToSearch;
            JTypeMirror p1 = targetType.getFormalParameters().get(0);
            JTypeMirror asSuper = p1.getAsSuper(type.getSymbol());
            if (asSuper != null && asSuper.isParameterizedType()) {
                typeToSearch = TypeConversion.capture(asSuper);
            }
        }
        JTypeMirror actualTypeToSearch = typeToSearch;
        boolean acceptsInstanceMethods = ExprOps.canUseInstanceMethods(actualTypeToSearch, targetType, mref);
        Predicate<JMethodSymbol> prefilter = TypeOps.accessibleMethodFilter(mref.getMethodName(), mref.getEnclosingType().getSymbol()).and(m -> Modifier.isStatic(m.getModifiers()) || acceptsInstanceMethods);
        return actualTypeToSearch.streamMethods(prefilter).collect(Collectors.toList());
    }

    private static boolean canUseInstanceMethods(JTypeMirror typeToSearch, JMethodSig sig, ExprMirror.MethodRefMirror mref) {
        if (mref.getLhsIfType() != null && !sig.getFormalParameters().isEmpty()) {
            JTypeMirror firstFormal = sig.getFormalParameters().get(0);
            return firstFormal.isSubtypeOf(typeToSearch);
        }
        return true;
    }

    static JMethodSig adaptGetClass(JMethodSig sig, Supplier<JTypeMirror> replacementReturnType) {
        TypeSystem ts = sig.getTypeSystem();
        if ("getClass".equals(sig.getName()) && sig.getDeclaringType().equals(ts.OBJECT)) {
            return InternalMethodTypeItf.cast(InternalMethodTypeItf.cast(sig).withReturnType(ExprOps.getClassReturn(replacementReturnType.get(), ts))).markAsAdapted();
        }
        return sig;
    }

    private static JTypeMirror getClassReturn(JTypeMirror erasedReceiverType, TypeSystem ts) {
        return ts.parameterise(ts.getClassSymbol(Class.class), CollectionUtil.listOf((Object)ts.wildcard(true, erasedReceiverType), (Object[])new JWildcardType[0]));
    }

    static boolean isContextDependent(JMethodSig m) {
        return (m = InternalMethodTypeItf.cast(m).adaptedMethod()).isGeneric() && TypeOps.mentionsAny(m.getReturnType(), m.getTypeParameters());
    }
}

