/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.internal;

import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.util.CollectionUtil;

public final class TestFrameworksUtil {
    private static final String JUNIT3_CLASS_NAME = "junit.framework.TestCase";
    private static final String JUNIT4_TEST_ANNOT = "org.junit.Test";
    private static final String TESTNG_TEST_ANNOT = "org.testng.annotations.Test";
    private static final Set<String> JUNIT5_ALL_TEST_ANNOTS = CollectionUtil.setOf((Object)"org.junit.jupiter.api.Test", (Object[])new String[]{"org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.api.TestFactory", "org.junit.jupiter.api.TestTemplate", "org.junit.jupiter.params.ParameterizedTest"});
    private static final String JUNIT5_NESTED = "org.junit.jupiter.api.Nested";
    private static final Set<String> ASSERT_CONTAINERS = CollectionUtil.setOf((Object)"org.junit.Assert", (Object[])new String[]{"org.junit.jupiter.api.Assertions", "org.hamcrest.MatcherAssert", "org.testng.Assert", "junit.framework.Assert", "junit.framework.TestCase"});
    private static final Set<String> TEST_CONFIGURATION_ANNOTATIONS = CollectionUtil.setOf((Object)"org.junit.Before", (Object[])new String[]{"org.junit.BeforeClass", "org.junit.After", "org.junit.AfterClass", "org.testng.annotations.AfterClass", "org.testng.annotations.AfterGroups", "org.testng.annotations.AfterMethod", "org.testng.annotations.AfterSuite", "org.testng.annotations.AfterTest", "org.testng.annotations.BeforeClass", "org.testng.annotations.BeforeGroups", "org.testng.annotations.BeforeMethod", "org.testng.annotations.BeforeSuite", "org.testng.annotations.BeforeTest"});

    private TestFrameworksUtil() {
    }

    public static boolean isJUnitMethod(ASTMethodDeclaration method) {
        if (method.hasModifiers(JModifier.STATIC, new JModifier[0]) || method.getBody() == null) {
            return false;
        }
        boolean result = TestFrameworksUtil.isJUnit5Method(method);
        result = result || TestFrameworksUtil.isJUnit4Method(method);
        result = result || TestFrameworksUtil.isJUnit3Method(method);
        return result;
    }

    public static boolean isTestMethod(ASTMethodDeclaration method) {
        return TestFrameworksUtil.isJUnitMethod(method) || TestFrameworksUtil.isTestNgMethod(method);
    }

    public static boolean isTestConfigurationMethod(ASTMethodDeclaration method) {
        return TEST_CONFIGURATION_ANNOTATIONS.stream().anyMatch(method::isAnnotationPresent) || TestFrameworksUtil.isJUnit3Class(method.getEnclosingType()) && ("setUp".equals(method.getName()) || "tearDown".equals(method.getName()));
    }

    private static boolean isTestNgMethod(ASTMethodDeclaration method) {
        return method.isAnnotationPresent(TESTNG_TEST_ANNOT);
    }

    public static boolean isJUnit4Method(ASTMethodDeclaration method) {
        return method.isAnnotationPresent(JUNIT4_TEST_ANNOT) && method.getVisibility() == ModifierOwner.Visibility.V_PUBLIC;
    }

    public static boolean isJUnit5Method(ASTMethodDeclaration method) {
        return method.getDeclaredAnnotations().any(it -> {
            String canonicalName = it.getTypeMirror().getSymbol().getCanonicalName();
            return JUNIT5_ALL_TEST_ANNOTS.contains(canonicalName);
        });
    }

    public static boolean isJUnit3Method(ASTMethodDeclaration method) {
        return TestFrameworksUtil.isJUnit3Class(method.getEnclosingType()) && TestFrameworksUtil.isJunit3MethodSignature(method);
    }

    public static boolean isJunit4TestAnnotation(ASTAnnotation annot) {
        return TypeTestUtil.isA(JUNIT4_TEST_ANNOT, (TypeNode)annot);
    }

    public static boolean isJunit3MethodSignature(ASTMethodDeclaration method) {
        return method.isVoid() && method.getVisibility() == ModifierOwner.Visibility.V_PUBLIC && method.getName().startsWith("test");
    }

    public static boolean isJUnit3Class(ASTTypeDeclaration node) {
        return node != null && node.isRegularClass() && !node.isNested() && !node.isAbstract() && TypeTestUtil.isA(JUNIT3_CLASS_NAME, (TypeNode)node);
    }

    public static boolean isTestClass(ASTTypeDeclaration node) {
        return node.isRegularClass() && !node.isAbstract() && !node.isNested() && (TestFrameworksUtil.isJUnit3Class(node) || node.getDeclarations(ASTMethodDeclaration.class).any(TestFrameworksUtil::isTestMethod));
    }

    public static boolean isJUnit5NestedClass(ASTTypeDeclaration innerClassDecl) {
        return innerClassDecl.isAnnotationPresent(JUNIT5_NESTED);
    }

    public static boolean isExpectExceptionCall(ASTMethodCall call) {
        return "expect".equals(call.getMethodName()) && TypeTestUtil.isA("org.junit.rules.ExpectedException", (TypeNode)call.getQualifier());
    }

    public static boolean isCallOnAssertionContainer(ASTMethodCall call) {
        JTypeMirror declaring = call.getMethodType().getDeclaringType();
        JTypeDeclSymbol sym = declaring.getSymbol();
        return sym instanceof JClassSymbol && (ASSERT_CONTAINERS.contains(((JClassSymbol)sym).getBinaryName()) || TypeTestUtil.isA("junit.framework.Assert", declaring));
    }

    public static boolean isProbableAssertCall(ASTMethodCall call) {
        String name = call.getMethodName();
        boolean isSoftAssertType = TestFrameworksUtil.isSoftAssert(call);
        return name.startsWith("assert") && !isSoftAssertType || "assertAll".equals(name) && isSoftAssertType || "assertSoftly".equals(name) && isSoftAssertType || name.startsWith("check") || name.startsWith("verify") || "fail".equals(name) || "failWith".equals(name) || TestFrameworksUtil.isExpectExceptionCall(call);
    }

    public static boolean isSoftAssert(ASTMethodCall call) {
        JTypeMirror declaringType = call.getMethodType().getDeclaringType();
        return TypeTestUtil.isA("org.assertj.core.api.StandardSoftAssertionsProvider", declaringType) || TypeTestUtil.isA("org.assertj.core.api.Java6StandardSoftAssertionsProvider", declaringType) || TypeTestUtil.isA("org.assertj.core.api.AbstractSoftAssertions", declaringType);
    }

    public static boolean isExpectAnnotated(ASTMethodDeclaration method) {
        return method.getDeclaredAnnotations().filter(annotation -> TestFrameworksUtil.isJunit4TestAnnotation(annotation) || TestFrameworksUtil.isTestNgMethod(method)).flatMap(ASTAnnotation::getMembers).any(it -> "expected".equals(it.getName()) || "expectedExceptions".equals(it.getName()));
    }
}

