/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.ASTYieldStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class VariableCanBeInlinedRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> STATEMENT_ORDER_MATTERS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"statementOrderMatters").defaultValue((Object)true)).desc("If set to false this rule no longer requires the variable declaration and return/throw statement to be on consecutive lines. Any variable that is used solely in a return/throw statement will be reported.")).build();

    public VariableCanBeInlinedRule() {
        super(ASTReturnStatement.class, ASTThrowStatement.class, ASTYieldStatement.class);
        this.definePropertyDescriptor(STATEMENT_ORDER_MATTERS);
    }

    public Object visit(ASTReturnStatement statement, Object data) {
        this.checkUnnecessaryLocal(statement, statement.getExpr(), data);
        return null;
    }

    public Object visit(ASTYieldStatement statement, Object data) {
        this.checkUnnecessaryLocal(statement, statement.getExpr(), data);
        return null;
    }

    public Object visit(ASTThrowStatement statement, Object data) {
        this.checkUnnecessaryLocal(statement, statement.getExpr(), data);
        return null;
    }

    private void checkUnnecessaryLocal(JavaNode statement, ASTExpression expr, Object data) {
        if (!(expr instanceof ASTVariableAccess)) {
            return;
        }
        JVariableSymbol sym = ((ASTVariableAccess)expr).getReferencedSym();
        if (sym == null) {
            return;
        }
        ASTVariableId varDecl = (ASTVariableId)sym.tryGetNode();
        if (varDecl == null || !varDecl.isLocalVariable() || varDecl.getDeclaredAnnotations().nonEmpty()) {
            return;
        }
        if (varDecl.getLocalUsages().size() != 1) {
            return;
        }
        if (!((Boolean)this.getProperty(STATEMENT_ORDER_MATTERS)).booleanValue() || ((ASTLocalVariableDeclaration)varDecl.ancestors(ASTLocalVariableDeclaration.class).firstOrThrow()).getNextSibling() == statement) {
            this.asCtx(data).addViolation((Node)varDecl, new Object[]{varDecl.getName()});
        }
    }
}

