/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.internal;

import java.util.Set;
import java.util.function.BiFunction;
import net.sourceforge.pmd.lang.ast.AstVisitor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAnonymousClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTContinueStatement;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLoopStatement;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchArrowBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchFallthroughBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLike;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.ASTYieldStatement;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.ReturnScopeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;

public final class NPathMetricCalculator {
    private NPathMetricCalculator() {
    }

    public static long computeNpath(ReturnScopeNode node) {
        ASTBlock body = node.getBody();
        if (body == null) {
            return 1L;
        }
        CfVisitState state = new CfVisitState(1L);
        state = body.acceptVisitor(CfVisitor.INSTANCE, state);
        return state.getNumPathsToExit();
    }

    private static DecisionPoint getControlFlowInCondition(ASTExpression e, CfPoint point) {
        return (DecisionPoint)e.acceptVisitor(CfExpressionVisitor.INSTANCE, new CfPoint(point));
    }

    static long saturatingAdd(long a, long b) {
        try {
            return Math.addExact(a, b);
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }

    static final class CfPoint
    implements DecisionPoint {
        private long numPathsUntilThisPoint;

        CfPoint(long start) {
            this.numPathsUntilThisPoint = start;
        }

        CfPoint(CfPoint clone) {
            this.numPathsUntilThisPoint = clone.numPathsUntilThisPoint;
        }

        CfPoint connectTo(CfPoint point) {
            point.numPathsUntilThisPoint = NPathMetricCalculator.saturatingAdd(point.numPathsUntilThisPoint, this.numPathsUntilThisPoint);
            return point;
        }

        CfPoint average(CfPoint point) {
            long halfThis = this.numPathsUntilThisPoint / 2L;
            long halfThat = point.numPathsUntilThisPoint / 2L;
            point.numPathsUntilThisPoint = NPathMetricCalculator.saturatingAdd(halfThis, halfThat);
            return point;
        }

        public String toString() {
            return this.numPathsUntilThisPoint + "";
        }

        @Override
        public CfPoint truePoint() {
            return this;
        }

        @Override
        public CfPoint falsePoint() {
            return this;
        }

        @Override
        public CfPoint endPaths() {
            return this;
        }

        @Override
        public DecisionPoint negate() {
            return this;
        }
    }

    static interface DecisionPoint {
        public CfPoint endPaths();

        public CfPoint truePoint();

        public CfPoint falsePoint();

        public DecisionPoint negate();
    }

    static final class CfVisitState {
        private PMap<String, CfPoint> labeledBreakPoints;
        private PMap<String, CfPoint> labeledContinuePoints;
        private @Nullable CfPoint breakPoint;
        private @Nullable CfPoint continuePoint;
        private @Nullable CfPoint yieldPoint;
        private final CfPoint returnPoint;
        private final CfPoint throwPoint;
        private final CfPoint loopBackPaths;
        private CfPoint currentProgramPoint;

        CfVisitState(long numPathsUntilThisPoint) {
            this.labeledBreakPoints = HashTreePMap.empty();
            this.labeledContinuePoints = HashTreePMap.empty();
            this.returnPoint = new CfPoint(0L);
            this.throwPoint = new CfPoint(0L);
            this.loopBackPaths = new CfPoint(0L);
            this.currentProgramPoint = new CfPoint(numPathsUntilThisPoint);
        }

        CfVisitState(CfVisitState state, CfPoint currentProgramPoint) {
            this.labeledBreakPoints = state.labeledBreakPoints;
            this.labeledContinuePoints = state.labeledContinuePoints;
            this.breakPoint = state.breakPoint;
            this.continuePoint = state.continuePoint;
            this.yieldPoint = state.yieldPoint;
            this.returnPoint = state.returnPoint;
            this.throwPoint = state.throwPoint;
            this.loopBackPaths = state.loopBackPaths;
            this.currentProgramPoint = currentProgramPoint;
        }

        CfVisitState fork() {
            return this.fork(this.currentProgramPoint);
        }

        CfVisitState fork(CfPoint currentPoint) {
            CfPoint newPoint = new CfPoint(currentPoint.numPathsUntilThisPoint);
            return new CfVisitState(this, newPoint);
        }

        CfVisitState absorb(CfPoint point) {
            point.connectTo(this.currentProgramPoint);
            return this;
        }

        CfVisitState withPoint(CfPoint point) {
            this.currentProgramPoint = point;
            return this;
        }

        @Nullable CfPoint getBreakPoint(@Nullable String label) {
            if (label == null) {
                return this.breakPoint;
            }
            return (CfPoint)this.labeledBreakPoints.get((Object)label);
        }

        @Nullable CfPoint getContinuePoint(@Nullable String label) {
            if (label == null) {
                return this.continuePoint;
            }
            return (CfPoint)this.labeledContinuePoints.get((Object)label);
        }

        CfVisitState abruptCompletion(CfPoint exitPoint) {
            if (exitPoint != null) {
                this.currentProgramPoint.connectTo(exitPoint);
            }
            this.currentProgramPoint.numPathsUntilThisPoint = 0L;
            return this;
        }

        long getNumPathsToExit() {
            return this.currentProgramPoint.connectTo(this.returnPoint).connectTo(this.throwPoint).connectTo(this.loopBackPaths).numPathsUntilThisPoint;
        }
    }

    static final class CfVisitor
    extends JavaVisitorBase<CfVisitState, CfVisitState> {
        static final CfVisitor INSTANCE = new CfVisitor();

        CfVisitor() {
        }

        protected CfVisitState visitChildren(Node node, CfVisitState state) {
            int numChildren = node.getNumChildren();
            for (int i = 0; i < numChildren; ++i) {
                state = (CfVisitState)node.getChild(i).acceptVisitor((AstVisitor)this, (Object)state);
            }
            return state;
        }

        @Override
        public CfVisitState visit(ASTBlock node, CfVisitState state) {
            return this.visitChildren((Node)node, state);
        }

        @Override
        public CfVisitState visit(ASTReturnStatement node, CfVisitState state) {
            if (node.getExpr() != null) {
                state = (CfVisitState)node.getExpr().acceptVisitor(this, state);
            }
            return state.abruptCompletion(state.returnPoint);
        }

        @Override
        public CfVisitState visit(ASTThrowStatement node, CfVisitState state) {
            state = (CfVisitState)node.getExpr().acceptVisitor(this, state);
            return state.abruptCompletion(state.throwPoint);
        }

        @Override
        public CfVisitState visit(ASTBreakStatement node, CfVisitState state) {
            return state.abruptCompletion(state.getBreakPoint(node.getLabel()));
        }

        @Override
        public CfVisitState visit(ASTYieldStatement node, CfVisitState state) {
            state = (CfVisitState)node.getExpr().acceptVisitor(this, state);
            return state.abruptCompletion(state.yieldPoint);
        }

        @Override
        public CfVisitState visit(ASTContinueStatement node, CfVisitState state) {
            return state.abruptCompletion(state.getContinuePoint(node.getLabel()));
        }

        @Override
        public CfVisitState visit(ASTIfStatement node, CfVisitState data) {
            return CfVisitor.handleLabelsForRegularStmt(node, data, (stmt, state) -> {
                DecisionPoint condition = NPathMetricCalculator.getControlFlowInCondition(stmt.getCondition(), ((CfVisitState)state).currentProgramPoint);
                CfVisitState thenState = (CfVisitState)stmt.getThenBranch().acceptVisitor(this, state.fork(condition.truePoint()));
                if (stmt.getElseBranch() != null) {
                    CfVisitState elseState = (CfVisitState)stmt.getElseBranch().acceptVisitor(this, state.fork(condition.falsePoint()));
                    return thenState.absorb(elseState.currentProgramPoint);
                }
                return thenState.absorb(condition.falsePoint());
            });
        }

        private CfVisitState visitSwitch(ASTSwitchLike switchLike, CfVisitState state) {
            CfVisitState startState = (CfVisitState)switchLike.getTestedExpression().acceptVisitor(this, state);
            long numPathsToStart = startState.currentProgramPoint.numPathsUntilThisPoint;
            CfVisitState currentFallthroughState = startState.fork(new CfPoint(0L));
            for (ASTSwitchBranch n : switchLike) {
                CfPoint thisBranch = new CfPoint(numPathsToStart * (long)JavaAstUtils.numAlternatives(n));
                if (n instanceof ASTSwitchFallthroughBranch) {
                    currentFallthroughState.absorb(thisBranch);
                    NodeStream<ASTStatement> statements = ((ASTSwitchFallthroughBranch)n).getStatements();
                    currentFallthroughState = (CfVisitState)statements.reduce((Object)currentFallthroughState, (point, stmt) -> (CfVisitState)stmt.acceptVisitor(this, point));
                    continue;
                }
                if (!(n instanceof ASTSwitchArrowBranch)) continue;
                CfVisitState branchState = startState.fork(thisBranch);
                branchState = (CfVisitState)((ASTSwitchArrowBranch)n).getRightHandSide().acceptVisitor(this, branchState);
                CfPoint exitPoint = switchLike instanceof ASTSwitchExpression ? branchState.yieldPoint : branchState.breakPoint;
                branchState.abruptCompletion(exitPoint);
            }
            if (!JavaAstUtils.isTotalSwitch(switchLike)) {
                currentFallthroughState.absorb(startState.currentProgramPoint);
            }
            return currentFallthroughState;
        }

        @Override
        public CfVisitState visit(ASTSwitchStatement node, CfVisitState data) {
            return CfVisitor.handleLabels(node, data, true, false, this::visitSwitch);
        }

        @Override
        public CfVisitState visit(ASTSwitchExpression node, CfVisitState state) {
            CfPoint prevYield = state.yieldPoint;
            state.yieldPoint = new CfPoint(0L);
            CfVisitState endState = this.visitSwitch(node, state);
            endState.absorb(state.yieldPoint);
            endState.yieldPoint = prevYield;
            return endState;
        }

        @Override
        public CfVisitState visit(ASTForeachStatement node, CfVisitState state) {
            return this.visitLoopExceptDoWhile(node, state, node.getIterableExpr(), null, node.getIterableExpr());
        }

        @Override
        public CfVisitState visit(ASTWhileStatement node, CfVisitState state) {
            return this.visitLoopExceptDoWhile(node, state, null, null, node.getCondition());
        }

        @Override
        public CfVisitState visit(ASTForStatement node, CfVisitState state) {
            return this.visitLoopExceptDoWhile(node, state, node.getInit(), node.getUpdate(), node.getCondition());
        }

        private CfVisitState visitLoopExceptDoWhile(ASTLoopStatement node, CfVisitState state, @Nullable JavaNode init, @Nullable JavaNode update, @Nullable ASTExpression conditionNode) {
            state = this.acceptOpt(init, state);
            DecisionPoint decision = this.getLoopCondition(conditionNode, state.currentProgramPoint);
            CfVisitState endState = CfVisitor.handleLabels(node, state.fork(decision.truePoint()), true, true, (loop, state2) -> {
                state2 = (CfVisitState)loop.getBody().acceptVisitor(this, state2);
                return this.acceptOpt(update, (CfVisitState)state2);
            }, (afterBody, breakPoint, contPoint) -> {
                assert (contPoint != null);
                return afterBody.absorb(breakPoint).absorb(contPoint);
            });
            if (JavaAstUtils.isUnconditionalLoop(node)) {
                return endState;
            }
            return endState.absorb(decision.falsePoint());
        }

        @Override
        public CfVisitState visit(ASTDoStatement node, CfVisitState state) {
            return CfVisitor.handleLabels(node, state, true, true, (loop, state2) -> (CfVisitState)loop.getBody().acceptVisitor(this, state2), (afterBody, breakPoint, contPoint) -> {
                assert (contPoint != null);
                CfPoint beforeCond = afterBody.currentProgramPoint.connectTo(contPoint);
                DecisionPoint condition = this.getLoopCondition(node.getCondition(), beforeCond);
                CfVisitState endState = afterBody.withPoint(condition.falsePoint()).absorb(breakPoint);
                condition.truePoint().connectTo(endState.loopBackPaths);
                return endState;
            });
        }

        private DecisionPoint getLoopCondition(@Nullable ASTExpression condition, CfPoint point) {
            if (condition != null) {
                return NPathMetricCalculator.getControlFlowInCondition(condition, point);
            }
            return point;
        }

        @Override
        public CfVisitState visitExpression(ASTExpression node, CfVisitState state) {
            CfPoint endPoint = NPathMetricCalculator.getControlFlowInCondition(node, state.currentProgramPoint).endPaths();
            return state.withPoint(endPoint);
        }

        private CfVisitState acceptOpt(@Nullable JavaNode node, CfVisitState state) {
            if (node == null) {
                return state;
            }
            return (CfVisitState)node.acceptVisitor(this, state);
        }

        private static <N extends ASTStatement> CfVisitState handleLabelsForRegularStmt(N stmt, CfVisitState state, BiFunction<N, CfVisitState, CfVisitState> action) {
            return CfVisitor.handleLabels(stmt, state, false, false, action);
        }

        private static <N extends ASTStatement> CfVisitState handleLabels(N stmt, CfVisitState state, boolean canBreakWithoutLabel, boolean canContinue, BiFunction<N, CfVisitState, CfVisitState> action) {
            return CfVisitor.handleLabels(stmt, state, canBreakWithoutLabel, canContinue, action, (endState, breakPoint, contPoint) -> endState.absorb(breakPoint));
        }

        private static <N extends ASTStatement> CfVisitState handleLabels(N stmt, CfVisitState state, boolean canBreakWithoutLabel, boolean canContinue, BiFunction<N, CfVisitState, CfVisitState> action, BreakAndContinueHandler callback) {
            Set<String> labels = JavaAstUtils.getStatementLabels(stmt);
            if (labels.isEmpty() && !canBreakWithoutLabel && !canContinue) {
                return action.apply(stmt, state);
            }
            PMap prevLabeledBreaks = state.labeledBreakPoints;
            PMap prevLabeledContinues = state.labeledContinuePoints;
            CfPoint prevBreak = state.breakPoint;
            CfPoint prevContinue = state.continuePoint;
            CfPoint breakPoint = new CfPoint(0L);
            for (String string : labels) {
                state.labeledBreakPoints = state.labeledBreakPoints.plus((Object)string, (Object)breakPoint);
            }
            if (canBreakWithoutLabel) {
                state.breakPoint = breakPoint;
            }
            CfPoint continuePoint = null;
            if (canContinue) {
                continuePoint = new CfPoint(0L);
                state.continuePoint = continuePoint;
                for (String label : labels) {
                    state.labeledContinuePoints = state.labeledContinuePoints.plus((Object)label, (Object)continuePoint);
                }
            }
            CfVisitState cfVisitState = action.apply(stmt, state);
            cfVisitState.continuePoint = prevContinue;
            cfVisitState.breakPoint = prevBreak;
            cfVisitState.labeledBreakPoints = prevLabeledBreaks;
            cfVisitState.labeledContinuePoints = prevLabeledContinues;
            return callback.handleBreakAndContinue(cfVisitState, breakPoint, continuePoint);
        }

        static interface BreakAndContinueHandler {
            public CfVisitState handleBreakAndContinue(CfVisitState var1, CfPoint var2, @Nullable CfPoint var3);
        }
    }

    static final class CfExpressionVisitor
    extends JavaVisitorBase<CfPoint, DecisionPoint> {
        static final CfExpressionVisitor INSTANCE = new CfExpressionVisitor();

        CfExpressionVisitor() {
        }

        @Override
        public DecisionPoint visitJavaNode(JavaNode node, CfPoint point) {
            for (JavaNode child : node.children()) {
                point = ((DecisionPoint)child.acceptVisitor(this, point)).endPaths();
            }
            return point;
        }

        @Override
        public DecisionPoint visit(ASTAnonymousClassDeclaration node, CfPoint point) {
            return point;
        }

        @Override
        public DecisionPoint visit(ASTLambdaExpression node, CfPoint point) {
            return point;
        }

        @Override
        public DecisionPoint visit(ASTConditionalExpression node, CfPoint point) {
            DecisionPoint condition = (DecisionPoint)node.getCondition().acceptVisitor(this, new CfPoint(point));
            DecisionPoint thenState = (DecisionPoint)node.getThenBranch().acceptVisitor(this, new CfPoint(condition.truePoint()));
            DecisionPoint elseState = (DecisionPoint)node.getElseBranch().acceptVisitor(this, new CfPoint(condition.falsePoint()));
            return new BooleanDecisionPoint(thenState.endPaths().connectTo(new CfPoint(elseState.endPaths())), thenState.truePoint().connectTo(new CfPoint(elseState.truePoint())), thenState.falsePoint().connectTo(new CfPoint(elseState.falsePoint())));
        }

        @Override
        public DecisionPoint visit(ASTUnaryExpression node, CfPoint point) {
            if (JavaAstUtils.isBooleanNegation(node)) {
                DecisionPoint condition = (DecisionPoint)node.getOperand().acceptVisitor(this, point);
                return condition.negate();
            }
            return (DecisionPoint)super.visit(node, point);
        }

        @Override
        public DecisionPoint visit(ASTInfixExpression node, CfPoint point) {
            if (node.getOperator() == BinaryOp.CONDITIONAL_AND) {
                DecisionPoint leftState = (DecisionPoint)node.getLeftOperand().acceptVisitor(this, point);
                DecisionPoint rightState = (DecisionPoint)node.getRightOperand().acceptVisitor(this, new CfPoint(leftState.truePoint()));
                return new BooleanDecisionPoint(leftState.endPaths().connectTo(new CfPoint(rightState.endPaths())), rightState.truePoint(), rightState.falsePoint().connectTo(leftState.falsePoint()));
            }
            if (node.getOperator() == BinaryOp.CONDITIONAL_OR) {
                DecisionPoint leftState = (DecisionPoint)node.getLeftOperand().acceptVisitor(this, point);
                DecisionPoint rightState = (DecisionPoint)node.getRightOperand().acceptVisitor(this, new CfPoint(leftState.falsePoint()));
                return new BooleanDecisionPoint(leftState.endPaths().connectTo(new CfPoint(rightState.endPaths())), rightState.truePoint().connectTo(leftState.truePoint()), rightState.falsePoint());
            }
            return (DecisionPoint)super.visit(node, point);
        }
    }

    static final class BooleanDecisionPoint
    implements DecisionPoint {
        CfPoint pointLeadingToThisDecision;
        final CfPoint truePoint;
        final CfPoint falsePoint;

        BooleanDecisionPoint(CfPoint pred, CfPoint truePoint, CfPoint falsePoint) {
            this.pointLeadingToThisDecision = pred;
            this.truePoint = truePoint;
            this.falsePoint = falsePoint;
        }

        @Override
        public CfPoint truePoint() {
            return this.truePoint;
        }

        @Override
        public CfPoint falsePoint() {
            return this.falsePoint;
        }

        @Override
        public CfPoint endPaths() {
            return this.pointLeadingToThisDecision;
        }

        @Override
        public DecisionPoint negate() {
            return new BooleanDecisionPoint(this.pointLeadingToThisDecision, this.falsePoint, this.truePoint);
        }
    }
}

