/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.InternalInterfaces;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum AssignmentOp implements InternalInterfaces.OperatorLike
{
    ASSIGN("=", null),
    AND_ASSIGN("&=", BinaryOp.AND),
    OR_ASSIGN("|=", BinaryOp.OR),
    XOR_ASSIGN("^=", BinaryOp.XOR),
    ADD_ASSIGN("+=", BinaryOp.ADD),
    SUB_ASSIGN("-=", BinaryOp.SUB),
    MUL_ASSIGN("*=", BinaryOp.MUL),
    DIV_ASSIGN("/=", BinaryOp.DIV),
    MOD_ASSIGN("%=", BinaryOp.MOD),
    LEFT_SHIFT_ASSIGN("<<=", BinaryOp.LEFT_SHIFT),
    RIGHT_SHIFT_ASSIGN(">>=", BinaryOp.RIGHT_SHIFT),
    UNSIGNED_RIGHT_SHIFT_ASSIGN(">>>=", BinaryOp.UNSIGNED_RIGHT_SHIFT);

    private final String code;
    private final BinaryOp binaryOp;

    private AssignmentOp(String code, BinaryOp binaryOp) {
        this.code = code;
        this.binaryOp = binaryOp;
    }

    @Override
    public String getToken() {
        return this.code;
    }

    public String toString() {
        return this.code;
    }

    public boolean isCompound() {
        return this != ASSIGN;
    }

    public @Nullable BinaryOp getBinaryOp() {
        return this.binaryOp;
    }
}

