/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.registry;

import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.registry.ParserDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

abstract class CompositeParserDescriptor
extends ParserDescriptor {
    CompositeParserDescriptor(String id, String name) {
        super(id, name);
    }

    @Override
    public final IssueParser create(ParserDescriptor.Option ... options) {
        return new CompositeParser(this.createParsers());
    }

    protected abstract Collection<? extends IssueParser> createParsers();

    protected Collection<? extends IssueParser> asList(IssueParser ... parser) {
        ArrayList parsers = new ArrayList();
        Collections.addAll(parsers, parser);
        return parsers;
    }

    private static class CompositeParser
    extends IssueParser {
        private static final long serialVersionUID = -2319098057308618997L;
        private final List<IssueParser> parsers = new ArrayList<IssueParser>();

        CompositeParser(Collection<? extends IssueParser> parsers) {
            this.parsers.addAll(parsers);
        }

        @Override
        protected Report parseReport(ReaderFactory readerFactory) {
            Report aggregated = new Report(this.getId(), this.getName(), readerFactory.getFileName(), this.getType());
            for (IssueParser parser : this.parsers) {
                if (!parser.accepts(readerFactory)) continue;
                parser.setId(this.getId());
                parser.setName(this.getName());
                parser.setType(this.getType());
                aggregated.addAll(parser.parse(readerFactory));
            }
            return aggregated;
        }
    }
}

