/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import j2html.TagCreator;
import j2html.tags.DomContent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.json.JSONArray;
import org.json.JSONObject;

public class VeraCodePipelineScannerParser
extends JsonIssueParser {
    private static final String VALUE_NOT_SET = "-";
    private static final int VERACODE_LOW_THRESHOLD = 2;
    private static final int VERACODE_HIGH_THRESHOLD = 4;
    private static final long serialVersionUID = 1L;

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        JSONArray findings = jsonReport.optJSONArray("findings");
        if (findings != null) {
            this.parseFindings(report, findings, issueBuilder);
        }
    }

    private void parseFindings(Report report, JSONArray resources, IssueBuilder issueBuilder) {
        for (int i = 0; i < resources.length(); ++i) {
            Object item = resources.get(i);
            if (!(item instanceof JSONObject)) continue;
            JSONObject finding = (JSONObject)item;
            report.add(this.convertToIssue(finding, issueBuilder));
        }
    }

    private Issue convertToIssue(JSONObject finding, IssueBuilder issueBuilder) {
        String rawFileName = this.getSourceFileField(finding, "file", VALUE_NOT_SET);
        String enrichedFileName = this.getEnrichedFileName(rawFileName);
        int line = this.getSourceFileField(finding, "line", 0);
        int severity = finding.getInt("severity");
        String title = finding.getString("title");
        String issueType = finding.getString("issue_type");
        String issueTypeId = finding.getString("issue_type_id");
        String scope = this.getSourceFileField(finding, "scope", VALUE_NOT_SET);
        String packageName = this.getPackageName(scope);
        return issueBuilder.setFileName(enrichedFileName).setLineStart(line).setSeverity(this.mapSeverity(severity)).setMessage(issueType).setPackageName(packageName).setType(title).setCategory(issueTypeId).setDescription(this.formatDescription(enrichedFileName, finding)).buildAndClean();
    }

    private String getEnrichedFileName(String rawFileName) {
        if (Strings.CS.endsWith((CharSequence)rawFileName, (CharSequence)".java") && !Strings.CS.startsWith((CharSequence)rawFileName, (CharSequence)"src/main/java/")) {
            return "src/main/java/" + rawFileName;
        }
        if (Strings.CS.endsWith((CharSequence)rawFileName, (CharSequence)".kt") && !Strings.CS.startsWith((CharSequence)rawFileName, (CharSequence)"src/main/kotlin/")) {
            return "src/main/kotlin/" + rawFileName;
        }
        return rawFileName;
    }

    private String getPackageName(String scope) {
        if (scope.contains(".")) {
            return StringUtils.substringBeforeLast((String)scope, (String)".");
        }
        return VALUE_NOT_SET;
    }

    private <T> T getSourceFileField(JSONObject finding, String key, T altValue) {
        JSONObject sourceFile;
        JSONObject files = finding.optJSONObject("files");
        if (files != null && (sourceFile = files.optJSONObject("source_file")) != null) {
            return (T)sourceFile.get(key);
        }
        return altValue;
    }

    private Severity mapSeverity(int severity) {
        if (severity <= 2) {
            return Severity.WARNING_LOW;
        }
        if (severity >= 4) {
            return Severity.WARNING_HIGH;
        }
        return Severity.WARNING_NORMAL;
    }

    private String formatDescription(String fileName, JSONObject finding) {
        String cweId = finding.optString("cwe_id", VALUE_NOT_SET);
        String flawLink = finding.optString("flaw_details_link", VALUE_NOT_SET);
        String severity = finding.optString("severity", VALUE_NOT_SET);
        String displayHtml = finding.optString("display_text", VALUE_NOT_SET);
        return TagCreator.join((Object[])new Object[]{TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"Resource: "), TagCreator.text((String)fileName)}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"CWE Id: "), TagCreator.text((String)cweId)}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"Flaw Details: "), TagCreator.text((String)flawLink)}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.b((String)"Severity: "), TagCreator.text((String)severity)}), TagCreator.p((DomContent[])new DomContent[]{TagCreator.rawHtml((String)displayHtml)})}).render();
    }
}

