/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import org.json.JSONArray;
import org.json.JSONObject;

public class ProtoLintJsonParser
extends JsonIssueParser {
    private static final long serialVersionUID = 573706779074579673L;

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        String basedir = jsonReport.optString("basedir");
        JSONArray results = jsonReport.optJSONArray("lints", new JSONArray(0));
        this.parseResults(report, basedir, results, issueBuilder);
    }

    private void parseResults(Report report, String basedir, JSONArray jsonReport, IssueBuilder issueBuilder) {
        for (int i = 0; i < jsonReport.length(); ++i) {
            JSONObject finding = (JSONObject)jsonReport.get(i);
            report.add(this.convertToIssue(basedir, finding, issueBuilder));
        }
    }

    private Issue convertToIssue(String basedir, JSONObject finding, IssueBuilder issueBuilder) {
        Object filename = finding.getString("filename");
        if (!basedir.isEmpty()) {
            filename = basedir + "/" + (String)filename;
        }
        return issueBuilder.setFileName((String)filename).setLineStart(finding.getInt("line")).setColumnStart(finding.getInt("column")).setMessage(finding.getString("message")).setSeverity(this.mapSeverity(finding.optString("severity"))).setType(finding.getString("rule")).buildAndClean();
    }

    private Severity mapSeverity(String aProtoLintSeverity) {
        return Severity.guessFromString(aProtoLintSeverity);
    }
}

