/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import org.json.JSONArray;
import org.json.JSONObject;

public class OtDockerLintParser
extends JsonIssueParser {
    private static final long serialVersionUID = 42L;

    @Override
    protected void parseJsonArray(Report report, JSONArray jsonReport, IssueBuilder issueBuilder) {
        for (Object entry : jsonReport) {
            if (!(entry instanceof JSONObject)) continue;
            JSONObject object = (JSONObject)entry;
            this.parseJsonObject(report, object, issueBuilder);
        }
    }

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonIssue, IssueBuilder issueBuilder) {
        if (jsonIssue.has("code")) {
            issueBuilder.setCategory(jsonIssue.getString("code"));
        }
        if (jsonIssue.has("severity")) {
            issueBuilder.setSeverity(Severity.guessFromString(jsonIssue.getString("severity")));
        }
        if (jsonIssue.has("line")) {
            issueBuilder.setLineStart(jsonIssue.getInt("line_number"));
        }
        if (jsonIssue.has("line")) {
            issueBuilder.setModuleName(jsonIssue.getString("line"));
        }
        if (jsonIssue.has("description")) {
            issueBuilder.setDescription(jsonIssue.getString("description"));
        }
        if (jsonIssue.has("message")) {
            issueBuilder.setMessage(jsonIssue.getString("message"));
        }
        if (jsonIssue.has("file")) {
            issueBuilder.setFileName(jsonIssue.getString("file"));
        }
        report.add(issueBuilder.buildAndClean());
    }
}

