/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class NpmAuditParser
extends JsonIssueParser {
    private static final long serialVersionUID = 1L;
    private static final String VALUE_NOT_SET = "-";
    private static final String UNCATEGORIZED = "Uncategorized";

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        JSONObject vulnerabilities = jsonReport.optJSONObject("vulnerabilities");
        if (vulnerabilities != null) {
            for (String name : vulnerabilities.keySet()) {
                this.parseVulnerability(report, vulnerabilities.getJSONObject(name), issueBuilder);
            }
        }
    }

    private void parseVulnerability(Report report, JSONObject vulnerability, IssueBuilder issueBuilder) {
        JSONArray via = vulnerability.optJSONArray("via");
        if (via != null) {
            List<String> tags = this.collectTags(vulnerability);
            for (Object object : via) {
                if (!(object instanceof JSONObject)) continue;
                JSONObject dependency = (JSONObject)object;
                report.add(this.convertToIssue(dependency, issueBuilder, tags));
            }
        }
    }

    private boolean hasFixAvailable(JSONObject vulnerability) {
        Object fixAvailable = vulnerability.opt("fixAvailable");
        if (fixAvailable instanceof Boolean) {
            Boolean fixAvailableValue = (Boolean)fixAvailable;
            return fixAvailableValue;
        }
        return fixAvailable != null;
    }

    private List<String> collectTags(JSONObject vulnerability) {
        ArrayList<String> tags = new ArrayList<String>();
        if (vulnerability.optBoolean("isDirect", false)) {
            tags.add("Direct");
        } else {
            tags.add("Indirect");
        }
        if (this.hasFixAvailable(vulnerability)) {
            tags.add("Fix Available");
        } else {
            tags.add("No Fix");
        }
        return tags;
    }

    private String formatDescription(JSONObject vulnerability, List<String> tags, SortedSet<String> weaknessCategories) {
        ContainerTag desc = TagCreator.p((DomContent[])new DomContent[]{TagCreator.b((String)vulnerability.optString("name", VALUE_NOT_SET)), TagCreator.text((String)" "), TagCreator.code((String)vulnerability.optString("range"))});
        if (!tags.isEmpty()) {
            desc = TagCreator.join((Object[])new Object[]{desc, TagCreator.p((String)String.join((CharSequence)", ", tags))});
        }
        ContainerTag details = TagCreator.p();
        details.with(new DomContent[]{TagCreator.b((String)"Score:"), TagCreator.text((String)" "), TagCreator.text((String)this.cvssScore(vulnerability))});
        String url = vulnerability.optString("url", null);
        if (url != null) {
            details.with(new DomContent[]{TagCreator.br(), TagCreator.b((String)"Reference:"), TagCreator.text((String)" "), TagCreator.a((String)url).withHref(url)});
        }
        if (!weaknessCategories.isEmpty()) {
            details.with(new DomContent[]{TagCreator.br(), TagCreator.b((String)"Weakness:"), (DomContent)weaknessCategories.stream().map(TagCreator::li).reduce(TagCreator.ul(), ContainerTag::with)});
        }
        return TagCreator.join((Object[])new Object[]{desc, details}).render();
    }

    private Issue convertToIssue(JSONObject vulnerability, IssueBuilder issueBuilder, List<String> tags) {
        SortedSet<String> weaknessCategories = this.collectWeaknessCategories(vulnerability);
        return issueBuilder.setPackageName(vulnerability.optString("name", VALUE_NOT_SET)).setMessage(vulnerability.optString("title", VALUE_NOT_SET)).guessSeverity(vulnerability.optString("severity", "UNKNOWN")).setDescription(this.formatDescription(vulnerability, tags, weaknessCategories)).setCategory(weaknessCategories.isEmpty() ? UNCATEGORIZED : weaknessCategories.first()).buildAndClean();
    }

    private String cvssScore(JSONObject vulnerability) {
        JSONObject cvss = vulnerability.optJSONObject("cvss");
        if (cvss != null) {
            return cvss.optString("score", VALUE_NOT_SET);
        }
        return VALUE_NOT_SET;
    }

    private SortedSet<String> collectWeaknessCategories(JSONObject viaObject) {
        TreeSet<String> weaknessCategories = new TreeSet<String>();
        JSONArray cwes = viaObject.optJSONArray("cwe");
        if (cwes != null) {
            for (Object object : cwes) {
                if (!(object instanceof String)) continue;
                String cweNumber = (String)object;
                weaknessCategories.add(cweNumber);
            }
        }
        return weaknessCategories;
    }
}

