/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Strings;

public class Gcc4CompilerParser
extends LookaheadParser {
    private static final long serialVersionUID = 5490211629355204910L;
    private static final String GCC_WARNING_PATTERN = "^(?:.*\\[[^]]*\\])?\\s*(.+?):(\\d+):(?:(\\d+):)? ?([wW]arning|.*[Ee]rror|[Nn]ote): (.*)$";
    private static final Pattern CLASS_PATTERN = Pattern.compile("\\[-W(.+)]$");
    private static final Pattern GCC_OPTION_PATTERN = Pattern.compile("\\[-(f[^\\]]+)]$");
    private static final Pattern CLANG_TIDY_PATTERN = Pattern.compile("\\[[^\\s\\]]+\\]$");
    private static final Pattern NOTE_PATTERN = Pattern.compile("^(?<file>.+?):(?<line>\\d+):(?:(?<column>\\d+):)? ?[Nn]ote: (?<message>.*)$");

    public Gcc4CompilerParser() {
        super(GCC_WARNING_PATTERN);
    }

    Gcc4CompilerParser(String pattern) {
        super(pattern);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return (line.contains("arning") || line.contains("rror") || line.contains("ote:")) && !line.contains("[javac]");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String messageStr;
        if (this.isNoteMessage(matcher)) {
            return Optional.empty();
        }
        StringBuilder message = new StringBuilder(matcher.group(5));
        String originalMessage = message.toString();
        this.setCategory(builder, originalMessage);
        boolean hasCodeSnippet = false;
        while (lookahead.hasNext() && Gcc4CompilerParser.isMessageContinuation(lookahead, hasCodeSnippet)) {
            String continuation = lookahead.next();
            if (continuation.length() > 0 && Character.isWhitespace(continuation.charAt(0))) {
                hasCodeSnippet = true;
            }
            message.append('\n');
            message.append(continuation);
        }
        String notes = this.getNotes(lookahead);
        if (!notes.isEmpty()) {
            message.append('\n');
            message.append(notes);
        }
        if (CLANG_TIDY_PATTERN.matcher(messageStr = message.toString()).find() && !CLASS_PATTERN.matcher(messageStr).find()) {
            return Optional.empty();
        }
        return builder.setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setColumnStart(matcher.group(3)).setMessage(messageStr).setSeverity(Severity.guessFromString(matcher.group(4))).buildOptional();
    }

    private boolean isNoteMessage(Matcher matcher) {
        String messageType = matcher.group(4);
        return "note".equals(messageType) || "Note".equals(messageType);
    }

    private void setCategory(IssueBuilder builder, String originalMessage) {
        Matcher classMatcher = CLASS_PATTERN.matcher(originalMessage);
        if (classMatcher.find() && classMatcher.group(1) != null) {
            builder.setCategory(classMatcher.group(1));
        } else {
            Matcher optionMatcher = GCC_OPTION_PATTERN.matcher(originalMessage);
            if (optionMatcher.find() && optionMatcher.group(1) != null) {
                builder.setCategory(optionMatcher.group(1));
            }
        }
    }

    private String getNotes(LookaheadStream lookahead) {
        String nextLine;
        Matcher noteMatcher;
        StringBuilder notes = new StringBuilder();
        while (lookahead.hasNext() && (noteMatcher = NOTE_PATTERN.matcher(nextLine = lookahead.peekNext())).matches()) {
            if (!notes.isEmpty()) {
                notes.append('\n');
            }
            notes.append(lookahead.next());
        }
        return notes.toString();
    }

    static boolean isMessageContinuation(LookaheadStream lookahead, boolean hasCodeSnippet) {
        String peek = lookahead.peekNext();
        if (peek.length() < 3) {
            return false;
        }
        return !Gcc4CompilerParser.startsWithInvalidCharacter(peek, hasCodeSnippet) && !Strings.CI.containsAny((CharSequence)peek, new CharSequence[]{"arning", "rror", "make"});
    }

    private static boolean startsWithInvalidCharacter(String peek, boolean hasCodeSnippet) {
        if (peek.charAt(0) == '/' || peek.charAt(0) == '[' || peek.charAt(0) == '<' || peek.charAt(0) == '=') {
            return true;
        }
        if (peek.charAt(1) == ':') {
            return true;
        }
        if (peek.charAt(2) == '/' || peek.charAt(0) == '\\') {
            return true;
        }
        return hasCodeSnippet && peek.startsWith("In file included from");
    }
}

