/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.io.UncheckedIOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class EmbeddedEngineerParser
extends IssueParser {
    private static final long serialVersionUID = -1251248150731418714L;
    private static final String LOG_BEGINNING_PATTERN = "^\\[.*?\\].*";
    private static final Pattern HEADER_PATTERN = Pattern.compile("^([^\\(Start)]*)(Starting code generation for)\\s(?<file>.*\\})");
    private static final Pattern SPECIAL_WARNING_PATTERN = Pattern.compile("^\\[([^\\]]*)\\]\\s(?<severity>Warn)\\s-\\s(?<description>[^']*)'(?<module>[^']*)'\\s(?<details>\\(?[^{]*)(?<serial>[^)]*\\})");
    private static final Pattern WARNING_PATTERN = Pattern.compile("^\\[([^\\]]*)\\]\\s(?<severity>Error|Warn)\\s-\\s(?<category>[^:]*)(:\\s|\\s\\()(?<description>.+)");

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Report parseReport(ReaderFactory reader) throws ParsingException {
        try (Stream<String> lines = reader.readStream();){
            Report report;
            try (LookaheadStream lookahead = new LookaheadStream(lines, reader.getFileName());){
                report = this.parse(lookahead);
            }
            return report;
        }
        catch (UncheckedIOException e) {
            throw new ParsingException(e, reader);
        }
    }

    private Report parse(LookaheadStream lookahead) {
        try (IssueBuilder builder = new IssueBuilder();){
            String file = this.parseFileName(lookahead);
            Report report = new Report();
            while (lookahead.hasNext() && lookahead.hasNext(LOG_BEGINNING_PATTERN)) {
                String description;
                String group;
                String lines = this.readMultipleLines(lookahead);
                Matcher matcher = SPECIAL_WARNING_PATTERN.matcher(lines);
                Matcher warningMatcher = WARNING_PATTERN.matcher(lines);
                if (!matcher.matches() && !warningMatcher.matches()) continue;
                if (matcher.matches()) {
                    group = matcher.group("severity");
                    description = "%s'%s' %s%s".formatted(matcher.group("description"), matcher.group("module"), matcher.group("details"), matcher.group("serial"));
                    builder.setCategory(this.setCategory(lines));
                    builder.setModuleName(matcher.group("module"));
                } else {
                    group = warningMatcher.group("severity");
                    builder.setCategory(warningMatcher.group("category"));
                    description = "%s %s".formatted(warningMatcher.group("category"), warningMatcher.group("description"));
                }
                Severity priority = this.mapPriority(lines, group);
                builder.setDescription(description);
                builder.setFileName(file);
                builder.setSeverity(priority);
                report.add(builder.build());
            }
            Report report2 = report;
            return report2;
        }
    }

    private String readMultipleLines(LookaheadStream lookahead) {
        StringBuilder multipleLines = new StringBuilder(lookahead.next());
        while (lookahead.hasNext() && !lookahead.hasNext(LOG_BEGINNING_PATTERN)) {
            multipleLines.append(" ").append(lookahead.next());
        }
        return multipleLines.toString();
    }

    private String parseFileName(LookaheadStream lineIterator) {
        while (lineIterator.hasNext()) {
            String line = lineIterator.next();
            Matcher matcher = HEADER_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            return matcher.group("file");
        }
        return "";
    }

    private String setCategory(String line) {
        if (line.contains("Complex type")) {
            return "Complex type definition without referenced element";
        }
        if (line.contains("skipped")) {
            return "Code generation skipped";
        }
        if (line.contains("failed")) {
            return "Code generation failed";
        }
        return "No Category";
    }

    private Severity mapPriority(String line, String group) {
        if (line.contains("Complex type") && group.contains("Warn")) {
            return Severity.WARNING_NORMAL;
        }
        if (line.contains("skipped") && group.contains("Warn")) {
            return Severity.WARNING_NORMAL;
        }
        if (line.contains("failed") && group.contains("Warn")) {
            return Severity.WARNING_HIGH;
        }
        if (group.contains("Error")) {
            return Severity.ERROR;
        }
        return Severity.WARNING_NORMAL;
    }
}

