/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.util.IntegerParser;
import edu.hm.hafner.util.LookaheadStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DrMemoryParser
extends LookaheadParser {
    private static final long serialVersionUID = 7195239138601238590L;
    private static final String DR_MEMORY_WARNING_PATTERN = "Error #\\d+: (.*)";
    private static final Pattern FILE_PATH_PATTERN = Pattern.compile("#\\s*\\d+.*?\\[(?<file>.*/?.*):(?<line>\\d+)]");
    private static final Pattern JENKINS_PATH_PATTERN = Pattern.compile(".*?(/jobs/.*?/workspace/|workspace/)");

    public DrMemoryParser() {
        super(DR_MEMORY_WARNING_PATTERN);
    }

    @Override
    @SuppressFBWarnings(value={"POTENTIAL_XML_INJECTION"}, justification="Message is cleaned in UI")
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) throws ParsingException {
        String header = matcher.group(1);
        StringBuilder messageBuilder = new StringBuilder(header);
        while (lookahead.hasNext("Elapsed time")) {
            messageBuilder.append("<br>");
            messageBuilder.append(lookahead.next());
        }
        StringBuilder stacktraceBuilder = new StringBuilder();
        while (lookahead.hasNext("^#.*")) {
            String stackTrace = lookahead.next();
            stacktraceBuilder.append(stackTrace);
            stacktraceBuilder.append("<br>");
            messageBuilder.append("<br>");
            messageBuilder.append(stackTrace);
        }
        while (lookahead.hasNext("^Note:")) {
            messageBuilder.append("<br>");
            messageBuilder.append(lookahead.next());
        }
        if (StringUtils.isNotBlank((CharSequence)header)) {
            this.assignCategoryAndSeverity(builder, header.toLowerCase(Locale.ENGLISH));
        }
        this.findOriginatingErrorLocation(stacktraceBuilder.toString(), builder);
        if (messageBuilder.length() == 0) {
            messageBuilder.append("Unknown Dr. Memory Error");
        }
        return builder.setMessage(messageBuilder.toString()).buildOptional();
    }

    private void assignCategoryAndSeverity(IssueBuilder builder, String header) {
        builder.setCategory("Unknown");
        builder.setSeverity(Severity.WARNING_NORMAL);
        if (header.startsWith("unaddressable access")) {
            builder.setCategory("Unaddressable Access");
            builder.setSeverity(Severity.WARNING_HIGH);
        } else if (header.startsWith("uninitialized read")) {
            builder.setCategory("Uninitialized Read");
            builder.setSeverity(Severity.WARNING_HIGH);
        } else if (header.startsWith("invalid heap argument")) {
            builder.setCategory("Invalid Heap Argument");
            builder.setSeverity(Severity.WARNING_HIGH);
        } else if (header.startsWith("reachable leak")) {
            builder.setCategory("Reachable Leak");
            builder.setSeverity(Severity.WARNING_HIGH);
        } else if (header.startsWith("leak")) {
            builder.setCategory("Leak");
            builder.setSeverity(Severity.WARNING_HIGH);
        } else if (header.startsWith("possible leak")) {
            builder.setCategory("Possible Leak");
        } else if (header.startsWith("gdi usage error")) {
            builder.setCategory("GDI Usage Error");
        } else if (header.startsWith("handle leak")) {
            builder.setCategory("Handle Leak");
        } else if (header.startsWith("warning")) {
            builder.setCategory("Warning");
        }
    }

    private void findOriginatingErrorLocation(String stackTrace, IssueBuilder builder) {
        builder.setFileName("-");
        builder.setLineStart(0);
        for (String line : stackTrace.split("<br>", -1)) {
            Matcher pathMatcher = FILE_PATH_PATTERN.matcher(line);
            if (!pathMatcher.find()) continue;
            String path = pathMatcher.group("file");
            builder.setFileName(path);
            builder.setLineStart(IntegerParser.parseInt(pathMatcher.group("line")));
            Matcher jenkinsPathMatcher = JENKINS_PATH_PATTERN.matcher(path);
            if (!jenkinsPathMatcher.find()) continue;
            return;
        }
    }
}

