/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.util.IntegerParser;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class CppLintParser
extends LookaheadParser {
    private static final long serialVersionUID = 1737791073711198075L;
    private static final String PATTERN = "^\\s*(.*)\\s*[(:](\\d+)\\)?:\\s*(.*)\\s*\\[(.*)\\] \\[(.*)\\]$";
    private static final int SEVERITY_HIGH_LIMIT = 5;
    private static final int SEVERITY_NORMAL_LIMIT = 3;

    public CppLintParser() {
        super(PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        Severity priority = this.mapPriority(matcher.group(5));
        return builder.setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setCategory(matcher.group(4)).setMessage(matcher.group(3)).setSeverity(priority).buildOptional();
    }

    private Severity mapPriority(String priority) {
        int value = IntegerParser.parseInt(priority);
        if (value >= 5) {
            return Severity.WARNING_HIGH;
        }
        if (value >= 3) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }
}

