/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClangParser
extends LookaheadParser {
    private static final long serialVersionUID = -3015592762345283182L;
    private static final String CLANG_WARNING_PATTERN = "^\\s*(?:\\d+%)?(C\\/C\\+\\+: )?([^%]*?):(\\d+):(?:(\\d+):)?(?:(?:\\{\\d+:\\d+-\\d+:\\d+\\})+:)?\\s*(warning|[^\\[\\]]*error):\\s*(.*?)(?:\\[([^\\[]*)\\])?$";
    private static final Pattern IGNORE_FORMAT = Pattern.compile("^-\\[.*\\].*$");

    public ClangParser() {
        super(CLANG_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String message = matcher.group(6);
        if (IGNORE_FORMAT.matcher(message).matches()) {
            return Optional.empty();
        }
        return builder.setFileName(matcher.group(2)).setLineStart(matcher.group(3)).setColumnStart(matcher.group(4)).setCategory(matcher.group(7)).setMessage(message).setSeverity(this.mapPriority(matcher.group(5))).buildOptional();
    }

    private Severity mapPriority(String type) {
        if (type.contains("error")) {
            return Severity.WARNING_HIGH;
        }
        return Severity.WARNING_NORMAL;
    }
}

