/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.AbstractModuleDetector;
import edu.hm.hafner.analysis.ModuleDetectorRunner;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

class OsgiModuleDetector
extends AbstractModuleDetector {
    static final String BUNDLE_PROPERTIES = "OSGI-INF/l10n/bundle.properties";
    static final String OSGI_BUNDLE = "META-INF/MANIFEST.MF";
    static final String PLUGIN_PROPERTIES = "plugin.properties";
    private static final String BUNDLE_NAME = "Bundle-Name";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_VENDOR = "Bundle-Vendor";
    private static final String REPLACEMENT_CHAR = "%";

    OsgiModuleDetector(ModuleDetectorRunner.FileSystemFacade fileSystemFacade) {
        super(fileSystemFacade);
    }

    @Override
    String getPattern() {
        return "**/META-INF/MANIFEST.MF";
    }

    @Override
    public void collectProjects(Map<String, String> mapping, List<String> projects) {
        for (String fileName : projects) {
            if (!fileName.endsWith(OSGI_BUNDLE)) continue;
            this.addMapping(mapping, fileName, OSGI_BUNDLE, this.parseManifest(fileName));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parseManifest(String manifestFile) {
        try (InputStream file = this.getFactory().open(manifestFile);){
            Manifest manifest = new Manifest(file);
            Attributes attributes = manifest.getMainAttributes();
            Properties properties = this.readProperties(StringUtils.substringBefore((String)manifestFile, (String)OSGI_BUNDLE));
            String name = this.getLocalizedValue(attributes, properties, BUNDLE_NAME);
            if (StringUtils.isNotBlank((CharSequence)name)) {
                String string2 = name;
                return string2;
            }
            String string = this.getSymbolicName(attributes, properties);
            return string;
        }
        catch (IOException | InvalidPathException exception) {
            return "";
        }
    }

    private Properties readProperties(String path) {
        Properties properties = new Properties();
        this.readProperties(path, properties, PLUGIN_PROPERTIES);
        this.readProperties(path, properties, BUNDLE_PROPERTIES);
        return properties;
    }

    private void readProperties(String path, Properties properties, String fileName) {
        try (InputStream file = this.getFactory().open(path + "/" + fileName);){
            properties.load(file);
        }
        catch (IOException | InvalidPathException exception) {
            // empty catch block
        }
    }

    private String getLocalizedValue(Attributes attributes, Properties properties, String bundleName) {
        String value = attributes.getValue(bundleName);
        if (Strings.CS.startsWith((CharSequence)StringUtils.trim((String)value), (CharSequence)REPLACEMENT_CHAR)) {
            return properties.getProperty(StringUtils.substringAfter((String)value, (String)REPLACEMENT_CHAR));
        }
        return value;
    }

    private String getSymbolicName(Attributes attributes, Properties properties) {
        String symbolicName = StringUtils.substringBefore((String)attributes.getValue(BUNDLE_SYMBOLIC_NAME), (String)";");
        if (StringUtils.isNotBlank((CharSequence)symbolicName)) {
            String vendor = this.getLocalizedValue(attributes, properties, BUNDLE_VENDOR);
            if (StringUtils.isNotBlank((CharSequence)vendor)) {
                return symbolicName + " (" + vendor + ")";
            }
            return symbolicName;
        }
        return "";
    }
}

