/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.ModuleDetectorRunner;
import edu.hm.hafner.analysis.Report;
import java.util.List;

public class ModuleResolver {
    private final ModuleDetectorRunner runner;

    public ModuleResolver(ModuleDetectorRunner runner) {
        this.runner = runner;
    }

    public void run(Report report) {
        List<Issue> issuesWithoutModule = report.stream().filter(issue -> !issue.hasModuleName()).toList();
        if (issuesWithoutModule.isEmpty()) {
            report.logInfo("-> all issues already have a valid module name", new Object[0]);
            return;
        }
        issuesWithoutModule.forEach(issue -> issue.setModuleName(this.runner.guessModuleName(issue.getAbsolutePath())));
        report.logInfo("-> resolved module names for %d issues", issuesWithoutModule.size());
    }
}

