/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.LookaheadStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public abstract class LookaheadParser
extends IssueParser {
    private static final long serialVersionUID = 3240719494150024894L;
    protected static final String ANT_TASK = "^(?:.*\\[[^]]*\\])?\\s*";
    private static final String ENTERING_DIRECTORY = "Entering directory";
    private static final String LEAVING_DIRECTORY = "Leaving directory";
    private static final Pattern ENTERING_DIRECTORY_PATH = Pattern.compile(".*Entering directory (?<dir>.*)");
    private static final String CMAKE_PREFIX = "-- Build files have";
    private static final Pattern CMAKE_PATH = Pattern.compile(".*-- Build files have been written to: (?<dir>.*)");
    private static final String HYPHEN = "'`";
    private static final int MAX_LINE_LENGTH = 4000;
    private static final String NO_DIRECTORY = "";
    private final Pattern pattern;
    private final Deque<String> recursiveDirectories;

    protected LookaheadParser(String pattern) {
        this.pattern = Pattern.compile(pattern);
        this.recursiveDirectories = new ArrayDeque<String>();
    }

    @Override
    public Report parseReport(ReaderFactory readerFactory) throws ParsingException, ParsingCanceledException {
        Report report = new Report();
        try (Stream<String> lines = readerFactory.readStream();
             LookaheadStream lookahead = new LookaheadStream(lines, readerFactory.getFileName());){
            this.parse(report, lookahead);
        }
        return this.postProcess(report);
    }

    private void parse(Report report, LookaheadStream lookahead) {
        try (IssueBuilder builder = new IssueBuilder();){
            while (lookahead.hasNext()) {
                Matcher matcher;
                String line = lookahead.next();
                this.handleDirectoryChanges(builder, line, report);
                this.preprocessLine(line);
                if (this.isLineInteresting(line) && (matcher = this.pattern.matcher(line)).find()) {
                    this.createIssue(matcher, lookahead, builder).ifPresent(report::add);
                }
                if (!Thread.interrupted()) continue;
                throw new ParsingCanceledException();
            }
        }
    }

    protected void preprocessLine(String line) {
    }

    private String enterDirectory(String line, Report log) {
        this.extractDirectory(line, ENTERING_DIRECTORY_PATH, log).ifPresent(this.recursiveDirectories::push);
        return this.recursiveDirectories.isEmpty() ? NO_DIRECTORY : this.recursiveDirectories.peek();
    }

    private String leaveDirectory() {
        if (!this.recursiveDirectories.isEmpty()) {
            this.recursiveDirectories.pop();
            if (!this.recursiveDirectories.isEmpty()) {
                return this.recursiveDirectories.peek();
            }
        }
        return NO_DIRECTORY;
    }

    private void handleDirectoryChanges(IssueBuilder builder, String line, Report log) {
        if (line.contains(ENTERING_DIRECTORY)) {
            builder.setDirectory(this.enterDirectory(line, log));
        } else if (line.contains(LEAVING_DIRECTORY)) {
            builder.setDirectory(this.leaveDirectory());
        } else if (line.contains(CMAKE_PREFIX)) {
            this.extractDirectory(line, CMAKE_PATH, log).ifPresent(builder::setDirectory);
        }
    }

    private Optional<String> extractDirectory(String line, Pattern makePath, Report log) throws ParsingException {
        if (!makePath.toString().contains("<dir>")) {
            throw new IllegalArgumentException("%s does not contain a capture group named 'dir'".formatted(makePath));
        }
        Matcher makeLineMatcher = makePath.matcher(line);
        if (makeLineMatcher.matches()) {
            return Optional.of(this.removeHyphen(makeLineMatcher.group("dir")));
        }
        log.logError("Unable to change directory using: %s to match %s", makePath.toString(), line);
        return Optional.empty();
    }

    protected abstract Optional<Issue> createIssue(Matcher var1, LookaheadStream var2, IssueBuilder var3) throws ParsingException;

    protected boolean isLineInteresting(String line) {
        return line.length() < 4000;
    }

    protected Report postProcess(Report report) {
        return report;
    }

    private String removeHyphen(String dir) {
        String path = dir;
        path = StringUtils.stripStart((String)path, (String)HYPHEN);
        path = StringUtils.stripEnd((String)path, (String)HYPHEN);
        return path;
    }
}

