/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class MutableClasses {
    private static final Set<String> KNOWN_IMMUTABLE_CLASSES = Set.of("java.lang.String", "java.lang.Integer", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Boolean", "java.lang.Long", "java.lang.Double", "java.lang.Float", "java.lang.StackTraceElement", "java.lang.Class", "java.lang.ClassLoader", "java.io.File", "java.awt.Font", "java.awt.BasicStroke", "java.awt.Color", "java.awt.GradientPaint", "java.awt.LinearGradientPaint", "java.awt.RadialGradientPaint", "java.awt.Cursor", "java.util.Locale", "java.util.UUID", "java.net.URL", "java.net.URI", "java.net.Inet4Address", "java.net.Inet6Address", "java.net.InetSocketAddress", "java.util.OptionalDouble", "java.util.OptionalInt", "java.util.OptionalLong", "java.util.regex.Pattern", "java.nio.charset.Charset", "java.nio.file.Path", "java.security.Permission", "java.lang.module.Configuration", "java.lang.module.ModuleDescriptor", "java.lang.module.ModuleReference", "java.lang.module.ResolvedModule", "java.lang.Module", "java.lang.ModuleLayer", "com.google.common.collect.ImmutableBiMap", "com.google.common.collect.ImmutableClassToInstanceMap", "com.google.common.collect.ImmutableCollection", "com.google.common.collect.ImmutableList", "com.google.common.collect.ImmutableListMultimap", "com.google.common.collect.ImmutableMap", "com.google.common.collect.ImmutableMultimap", "com.google.common.collect.ImmutableMultiset", "com.google.common.collect.ImmutableRangeMap", "com.google.common.collect.ImmutableRangeSet", "com.google.common.collect.ImmutableSet", "com.google.common.collect.ImmutableSetMultimap", "com.google.common.collect.ImmutableSortedMap", "com.google.common.collect.ImmutableSortedMultiset", "com.google.common.collect.ImmutableSortedSet", "com.google.common.collect.ImmutableTable", "java.util.Collections$EmptyList", "java.util.Collections$EmptyMap", "java.util.Collections$EmptyNavigableMap", "java.util.Collections$EmptySet", "java.util.Collections$EmptyNavigableSet", "java.util.Collections$SingletonList", "java.util.Collections$SingletonMap", "java.util.Collections$SingletonSet", "java.util.Collections$UnmodifiableList", "java.util.Collections$UnmodifiableMap", "java.util.Collections$UnmodifiableNavigableMap", "java.util.Collections$UnmodifiableSortedMap", "java.util.Collections$UnmodifiableSet", "java.util.Collections$UnmodifiableNavigableSet", "java.util.Collections$UnmodifiableSortedSet", "java.util.ImmutableCollections$AbstractImmutableList", "java.util.ImmutableCollections$AbstractImmutableMap", "java.util.ImmutableCollections$AbstractImmutableSet");
    private static final Set<String> KNOWN_IMMUTABLE_PACKAGES = Set.of("java.math", "java.time", "java.util.function", "java.lang.constant");
    private static final Set<String> CONSTRUCTOR_LIKE_NAMES = Set.of("<init>", "<clinit>", "clone", "init", "initialize", "dispose", "finalize", "this", "_jspInit", "jspDestroy");
    private static final List<String> SETTER_LIKE_PREFIXES = List.of("set", "put", "add", "insert", "delete", "remove", "erase", "clear", "push", "pop", "enqueue", "dequeue", "write", "append", "replace");

    public static boolean mutableSignature(String sig) {
        String dottedPackageName;
        if (sig.charAt(0) == '[') {
            return true;
        }
        if (sig.charAt(0) != 'L') {
            return false;
        }
        String dottedClassName = ClassName.fromFieldSignatureToDottedClassName(sig);
        int lastDot = dottedClassName.lastIndexOf(46);
        if (lastDot >= 0 && KNOWN_IMMUTABLE_PACKAGES.contains(dottedPackageName = dottedClassName.substring(0, lastDot))) {
            return false;
        }
        if (KNOWN_IMMUTABLE_CLASSES.contains(dottedClassName)) {
            return false;
        }
        try {
            JavaClass cls = Repository.lookupClass((String)dottedClassName);
            if (Stream.of(cls.getAnnotationEntries()).map(AnnotationEntry::getAnnotationType).anyMatch(type -> type.endsWith("/Immutable;") || type.equals("Ljdk/internal/ValueBased;"))) {
                return false;
            }
            JavaClass ann = Repository.lookupClass((String)"java.lang.annotation.Annotation");
            if (cls.instanceOf(ann)) {
                return false;
            }
            return ClassAnalysis.load(cls, sig).isMutable();
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return false;
        }
    }

    public static boolean isConstructorLikeMethod(String methodName) {
        return CONSTRUCTOR_LIKE_NAMES.contains(methodName);
    }

    public static boolean looksLikeASetter(String methodName, String classSig, String retSig) {
        if (Objects.equals(classSig, retSig)) {
            return false;
        }
        return MutableClasses.looksLikeASetter(methodName);
    }

    public static boolean looksLikeASetter(String methodName) {
        return SETTER_LIKE_PREFIXES.stream().anyMatch(methodName::startsWith);
    }

    private static final class ClassAnalysis {
        private final JavaClass cls;
        private ClassAnalysis superAnalysis;
        private String sig;
        private Boolean mutable;
        private Boolean immutableByContract;

        private ClassAnalysis(JavaClass cls, String sig) {
            this.cls = cls;
            this.sig = sig;
        }

        static ClassAnalysis load(JavaClass cls, String sig) {
            return new ClassAnalysis(cls, sig);
        }

        boolean isMutable() {
            Boolean local = this.mutable;
            if (local == null) {
                this.mutable = local = Boolean.valueOf(this.computeMutable());
            }
            return local;
        }

        private boolean computeMutable() {
            if (this.isImmutableByContract()) {
                return false;
            }
            for (Method method : this.cls.getMethods()) {
                if (method.isStatic() || !this.looksLikeASetter(method)) continue;
                return true;
            }
            ClassAnalysis maybeSuper = this.getSuperAnalysis();
            return maybeSuper != null && maybeSuper.isMutable();
        }

        private boolean looksLikeASetter(Method method) {
            return MutableClasses.looksLikeASetter(method.getName(), this.getSig(), method.getReturnType().getSignature());
        }

        private String getSig() {
            Object local = this.sig;
            if (local == null) {
                this.sig = local = "L" + ClassName.toSlashedClassName(this.cls.getClassName()) + ";";
            }
            return local;
        }

        private boolean isImmutableByContract() {
            Boolean local = this.immutableByContract;
            if (local == null) {
                this.immutableByContract = local = Boolean.valueOf(this.computeByImmutableContract());
            }
            return local;
        }

        private boolean computeByImmutableContract() {
            if ("java.lang.Enum".equals(this.cls.getClassName())) {
                return true;
            }
            if ("java.lang.Record".equals(this.cls.getClassName())) {
                return true;
            }
            for (AnnotationEntry entry : this.cls.getAnnotationEntries()) {
                if (!entry.getAnnotationType().equals("Lcom/google/errorprone/annotations/Immutable;")) continue;
                return true;
            }
            ClassAnalysis maybeSuper = this.getSuperAnalysis();
            return maybeSuper != null && maybeSuper.isImmutableByContract();
        }

        private ClassAnalysis getSuperAnalysis() {
            ClassAnalysis local = this.superAnalysis;
            if (local == null) {
                this.superAnalysis = local = this.loadSuperAnalysis();
            }
            return local;
        }

        private ClassAnalysis loadSuperAnalysis() {
            JavaClass superClass;
            String superName = this.cls.getSuperclassName();
            if (superName == null || superName.equals("java.lang.Object")) {
                return null;
            }
            try {
                superClass = this.cls.getSuperClass();
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass(e);
                return null;
            }
            if (superClass == null) {
                return null;
            }
            return ClassAnalysis.load(superClass, null);
        }
    }
}

