/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugsDisplayFeatures;
import edu.umd.cs.findbugs.IGuiCallback;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectPackagePrefixes;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.gui2.AboutDialog;
import edu.umd.cs.findbugs.gui2.AbstractSwingGuiCallback;
import edu.umd.cs.findbugs.gui2.BugAspects;
import edu.umd.cs.findbugs.gui2.BugLeafNode;
import edu.umd.cs.findbugs.gui2.BugLoader;
import edu.umd.cs.findbugs.gui2.BugSet;
import edu.umd.cs.findbugs.gui2.BugTreeModel;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FBFrame;
import edu.umd.cs.findbugs.gui2.FindBugsLayoutManager;
import edu.umd.cs.findbugs.gui2.FindBugsLayoutManagerFactory;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import edu.umd.cs.findbugs.gui2.MainFrameComponentFactory;
import edu.umd.cs.findbugs.gui2.MainFrameHelper;
import edu.umd.cs.findbugs.gui2.MainFrameLoadSaveHelper;
import edu.umd.cs.findbugs.gui2.MainFrameMenu;
import edu.umd.cs.findbugs.gui2.MainFrameTree;
import edu.umd.cs.findbugs.gui2.NewProjectWizard;
import edu.umd.cs.findbugs.gui2.PreferencesFrame;
import edu.umd.cs.findbugs.gui2.ProjectSettings;
import edu.umd.cs.findbugs.gui2.SaveType;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.SorterTableColumnModel;
import edu.umd.cs.findbugs.gui2.SourceCodeDisplay;
import edu.umd.cs.findbugs.gui2.SwingThread;
import edu.umd.cs.findbugs.gui2.ViewFilter;
import edu.umd.cs.findbugs.log.ConsoleLogger;
import edu.umd.cs.findbugs.log.LogSync;
import edu.umd.cs.findbugs.log.Logger;
import edu.umd.cs.findbugs.sourceViewer.NavigableTextPane;
import edu.umd.cs.findbugs.util.Multiset;
import edu.umd.cs.findbugs.util.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public class MainFrame
extends FBFrame
implements LogSync {
    public static final boolean GUI2_DEBUG = SystemProperties.getBoolean("gui2.debug");
    public static final boolean MAC_OS_X = SystemProperties.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private static final int SEARCH_TEXT_FIELD_SIZE = 32;
    public static final String TITLE_START_TXT = "SpotBugs";
    private static final String WINDOW_MODIFIED = "windowModified";
    public static final boolean USE_WINDOWS_LAF = false;
    private static MainFrame instance;
    private final MyGuiCallback guiCallback = new MyGuiCallback();
    private BugCollection bugCollection;
    private BugAspects currentSelectedBugAspects;
    private volatile Project curProject = new Project();
    private volatile boolean newProject = false;
    private final ProjectPackagePrefixes projectPackagePrefixes = new ProjectPackagePrefixes();
    private final Logger logger = new ConsoleLogger(this);
    @CheckForNull
    private File saveFile = null;
    private final ExecutorService backgroundExecutor = Executors.newCachedThreadPool();
    private final CountDownLatch mainFrameInitialized = new CountDownLatch(1);
    private int waitCount = 0;
    private final Object waitLock = new Object();
    private volatile String errorMsg = "";
    private boolean projectChanged = false;
    private final FindBugsLayoutManager guiLayout;
    private final JLabel statusBarLabel = new JLabel();
    private final JTextField sourceSearchTextField = new JTextField(32);
    private final JButton findButton = MainFrameHelper.newButton("button.find", "First");
    private final JButton findNextButton = MainFrameHelper.newButton("button.findNext", "Next");
    private final JButton findPreviousButton = MainFrameHelper.newButton("button.findPrev", "Previous");
    private final NavigableTextPane sourceCodeTextPane = new NavigableTextPane();
    private JPanel summaryTopPanel;
    JEditorPane summaryHtmlArea = new JEditorPane();
    private final JScrollPane summaryHtmlScrollPane = new JScrollPane(this.summaryHtmlArea);
    private final SourceCodeDisplay displayer = new SourceCodeDisplay(this);
    private final ViewFilter viewFilter = new ViewFilter(this);
    private SaveType saveType = SaveType.NOT_KNOWN;
    private final MainFrameLoadSaveHelper mainFrameLoadSaveHelper = new MainFrameLoadSaveHelper(this);
    final MainFrameTree mainFrameTree = new MainFrameTree(this);
    final MainFrameMenu mainFrameMenu = new MainFrameMenu(this);
    private final MainFrameComponentFactory mainFrameComponentFactory = new MainFrameComponentFactory(this);
    volatile Exception previousDecrementToZero;

    public static void makeInstance(FindBugsLayoutManagerFactory factory) {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = new MainFrame(factory);
        instance.initializeGUI();
    }

    public static MainFrame getInstance() {
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }

    private MainFrame(FindBugsLayoutManagerFactory factory) {
        this.guiLayout = factory.getInstance(this);
        FindBugsDisplayFeatures.setAbridgedMessages(true);
    }

    public void showMessageDialog(String message) {
        this.guiCallback.showMessageDialog(message);
    }

    public int showConfirmDialog(String message, String title, String ok, String cancel) {
        return this.guiCallback.showConfirmDialog(message, title, ok, cancel);
    }

    public IGuiCallback getGuiCallback() {
        return this.guiCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireDisplayWait() {
        Object object = this.waitLock;
        synchronized (object) {
            ++this.waitCount;
            if (GUI2_DEBUG) {
                System.err.println("acquiring display wait, count " + this.waitCount);
                Thread.dumpStack();
            }
            if (this.waitCount == 1) {
                this.mainFrameTree.showCard(BugCard.WAITCARD, new Cursor(3), this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDisplayWait() {
        Object object = this.waitLock;
        synchronized (object) {
            if (this.waitCount <= 0) {
                if (this.previousDecrementToZero != null) {
                    throw new IllegalStateException("Can't decrease wait count; already zero", this.previousDecrementToZero);
                }
                throw new IllegalStateException("Can't decrease wait count; never incremented");
            }
            --this.waitCount;
            if (GUI2_DEBUG) {
                System.err.println("releasing display wait, count " + this.waitCount);
                Thread.dumpStack();
            }
            if (this.waitCount == 0) {
                this.mainFrameTree.showCard(BugCard.TREECARD, new Cursor(0), this);
                this.previousDecrementToZero = new Exception("Previously decremented at");
            }
        }
    }

    public void waitUntilReady() throws InterruptedException {
        this.mainFrameInitialized.await();
    }

    public JTree getTree() {
        return this.mainFrameTree.getTree();
    }

    public BugTreeModel getBugTreeModel() {
        return this.mainFrameTree.getBugTreeModel();
    }

    @Nonnull
    public synchronized Project getProject() {
        if (this.curProject == null) {
            this.curProject = new Project();
        }
        return this.curProject;
    }

    public synchronized void setProject(Project p) {
        this.curProject = p;
    }

    public void setProjectChanged(boolean b) {
        if (this.curProject == null) {
            return;
        }
        if (this.projectChanged == b) {
            return;
        }
        this.projectChanged = b;
        this.mainFrameMenu.setSaveMenu(this);
        this.getRootPane().putClientProperty(WINDOW_MODIFIED, b);
    }

    @Override
    public void error(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    @Override
    public void writeToLog(String message) {
        if (GUI2_DEBUG) {
            System.out.println(message);
        }
    }

    public int showConfirmDialog(String message, String title, int optionType) {
        return JOptionPane.showConfirmDialog(this, message, title, optionType);
    }

    public Sortables[] getAvailableSortables() {
        return this.mainFrameTree.getAvailableSortables();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        float size = Driver.getFontSize();
        JMenuBar menubar = this.getJMenuBar();
        if (menubar != null) {
            menubar.setFont(menubar.getFont().deriveFont(size));
            for (int i = 0; i < menubar.getMenuCount(); ++i) {
                for (int j = 0; j < menubar.getMenu(i).getMenuComponentCount(); ++j) {
                    Component temp = menubar.getMenu(i).getMenuComponent(j);
                    temp.setFont(temp.getFont().deriveFont(size));
                }
            }
            this.mainFrameTree.updateFonts(size);
        }
    }

    @SwingThread
    void updateStatusBar() {
        int countFilteredBugs = BugSet.countFilteredBugs();
        Object msg = "";
        if (countFilteredBugs == 1) {
            msg = "  1 " + L10N.getLocalString("statusbar.bug_hidden", "bug hidden (see view menu)");
        } else if (countFilteredBugs > 1) {
            msg = "  " + countFilteredBugs + " " + L10N.getLocalString("statusbar.bugs_hidden", "bugs hidden (see view menu)");
        }
        if (this.errorMsg != null && this.errorMsg.length() > 0) {
            msg = MainFrame.join((String)msg, this.errorMsg);
        }
        this.mainFrameTree.setWaitStatusLabelText((String)msg);
        if (((String)msg).length() == 0) {
            msg = "https://github.com/spotbugs";
        }
        this.statusBarLabel.setText((String)msg);
    }

    void callOnClose() {
        if (this.projectChanged && !SystemProperties.getBoolean("findbugs.skipSaveChangesWarning")) {
            Object[] options = new Object[]{L10N.getLocalString("dlg.save_btn", "Save"), L10N.getLocalString("dlg.dontsave_btn", "Don't Save"), L10N.getLocalString("dlg.cancel_btn", "Cancel")};
            int value = JOptionPane.showOptionDialog(this, this.getActionWithoutSavingMsg("closing"), L10N.getLocalString("msg.confirm_save_txt", "Do you want to save?"), 1, 3, null, options, options[0]);
            if (value == 2 || value == -1) {
                return;
            }
            if (value == 0) {
                if (this.saveFile == null) {
                    if (!this.mainFrameLoadSaveHelper.saveAs()) {
                        return;
                    }
                } else {
                    this.mainFrameLoadSaveHelper.save();
                }
            }
        }
        GUISaveState guiSaveState = GUISaveState.getInstance();
        this.guiLayout.saveState();
        guiSaveState.setFrameBounds(this.getBounds());
        guiSaveState.setExtendedWindowState(this.getExtendedState());
        guiSaveState.save();
        System.exit(0);
    }

    JMenuItem createRecentItem(File f, SaveType localSaveType) {
        return this.mainFrameMenu.createRecentItem(f, localSaveType);
    }

    public boolean openAnalysis(File f, SaveType saveType) {
        if (!f.exists() || !f.canRead()) {
            throw new IllegalArgumentException("Can't read " + f.getPath());
        }
        this.mainFrameLoadSaveHelper.prepareForFileLoad(f, saveType);
        this.mainFrameLoadSaveHelper.loadAnalysis(f);
        return true;
    }

    public void openBugCollection(SortedBugCollection bugs) {
        this.acquireDisplayWait();
        try {
            this.mainFrameLoadSaveHelper.prepareForFileLoad(null, null);
            Project project = bugs.getProject();
            project.setGuiCallback(this.guiCallback);
            BugLoader.addDeadBugMatcher(bugs);
            this.setProjectAndBugCollectionInSwingThread(project, bugs);
        }
        finally {
            this.releaseDisplayWait();
        }
    }

    void clearBugCollection() {
        this.setSaveFile(null);
        this.setProjectAndBugCollection(null, null);
    }

    @SwingThread
    void setBugCollection(BugCollection bugCollection) {
        this.setProjectAndBugCollection(bugCollection.getProject(), bugCollection);
    }

    void setProjectAndBugCollectionInSwingThread(Project project, BugCollection bc) {
        this.setProjectAndBugCollection(project, bc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SwingThread
    private void setProjectAndBugCollection(@CheckForNull Project project, @CheckForNull BugCollection bugCollection) {
        if (GUI2_DEBUG) {
            if (bugCollection == null) {
                System.out.println("Setting bug collection to null");
            } else {
                System.out.println("Setting bug collection; contains " + bugCollection.getCollection().size() + " bugs");
            }
        }
        if (bugCollection != null && bugCollection.getProject() != project) {
            Project p2 = bugCollection.getProject();
            throw new IllegalArgumentException(String.format("project %x and bug collection %x don't match", System.identityHashCode(project), System.identityHashCode(p2)));
        }
        this.acquireDisplayWait();
        try {
            this.setProject(project);
            this.bugCollection = bugCollection;
            BugLoader.addDeadBugMatcher(bugCollection);
            this.displayer.clearCache();
            this.mainFrameTree.updateBugTree();
            this.setProjectChanged(false);
            Runnable runnable = () -> {
                PreferencesFrame.getInstance().updateFilterPanel();
                this.mainFrameMenu.getReconfigMenuItem().setEnabled(true);
                this.mainFrameMenu.setViewMenu();
                this.newProject();
                this.clearSourcePane();
                this.clearSummaryTab();
                this.updateTitle();
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        finally {
            this.releaseDisplayWait();
        }
    }

    void updateProjectAndBugCollection(BugCollection bugCollection) {
        if (bugCollection != null) {
            this.displayer.clearCache();
            BugSet bs = new BugSet(bugCollection);
            BugTreeModel model = (BugTreeModel)this.mainFrameTree.getTree().getModel();
            model.getOffListenerList();
            model.changeSet(bs);
            this.setProjectChanged(true);
        }
        this.setCursor(new Cursor(0));
    }

    boolean shouldDisplayIssue(BugInstance b) {
        Project project = this.getProject();
        Filter suppressionFilter = project.getSuppressionFilter();
        if (null == this.getBugCollection() || suppressionFilter.match(b)) {
            return false;
        }
        return this.viewFilter.show(b);
    }

    public void createNewProjectFromMenuItem() {
        new NewProjectWizard();
        this.newProject = true;
    }

    void newProject() {
        this.clearSourcePane();
        if (!FindBugs.isNoAnalysis()) {
            this.mainFrameMenu.enableOrDisableItems(this.curProject, this.bugCollection);
        }
        if (this.newProject) {
            this.setProjectChanged(true);
            this.saveFile = null;
            this.mainFrameMenu.getSaveMenuItem().setEnabled(false);
            this.mainFrameMenu.getReconfigMenuItem().setEnabled(true);
            this.newProject = false;
        }
    }

    void about() {
        AboutDialog dialog = new AboutDialog(this, this.logger, true);
        dialog.setSize(600, 554);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    void preferences() {
        PreferencesFrame.getInstance().setLocationRelativeTo(this);
        PreferencesFrame.getInstance().setVisible(true);
    }

    void redoAnalysis() {
        this.acquireDisplayWait();
        Util.runInDameonThread(() -> {
            try {
                Project project = this.getProject();
                BugCollection bc = BugLoader.redoAnalysisKeepComments(project);
                this.updateProjectAndBugCollection(bc);
                this.setProjectAndBugCollectionInSwingThread(project, bc);
            }
            finally {
                this.releaseDisplayWait();
            }
        });
    }

    void syncBugInformation() {
        boolean prevProjectChanged = this.projectChanged;
        if (this.mainFrameTree.getCurrentSelectedBugLeaf() != null) {
            BugInstance bug = this.mainFrameTree.getCurrentSelectedBugLeaf().getBug();
            this.displayer.displaySource(bug, bug.getPrimarySourceLineAnnotation());
            this.updateSummaryTab(this.mainFrameTree.getCurrentSelectedBugLeaf());
        } else if (this.currentSelectedBugAspects != null) {
            this.displayer.displaySource(null, null);
            this.clearSummaryTab();
        } else {
            this.displayer.displaySource(null, null);
            this.clearSummaryTab();
        }
        this.setProjectChanged(prevProjectChanged);
    }

    void clearSourcePane() {
        SwingUtilities.invokeLater(() -> {
            this.mainFrameComponentFactory.setSourceTab("", null);
            this.sourceCodeTextPane.setDocument(SourceCodeDisplay.SOURCE_NOT_RELEVANT);
        });
    }

    private void initializeGUI() {
        this.mainFrameComponentFactory.initializeGUI();
    }

    JPanel statusBar() {
        return this.mainFrameComponentFactory.statusBar();
    }

    JSplitPane summaryTab() {
        return this.mainFrameComponentFactory.summaryTab();
    }

    JPanel createSourceCodePanel() {
        return this.mainFrameComponentFactory.createSourceCodePanel();
    }

    JPanel createSourceSearchPanel() {
        return this.mainFrameComponentFactory.createSourceSearchPanel();
    }

    void setSourceTab(String title, @CheckForNull BugInstance bug) {
        this.mainFrameComponentFactory.setSourceTab(title, bug);
    }

    SorterTableColumnModel getSorter() {
        return this.mainFrameTree.getSorter();
    }

    private String getActionWithoutSavingMsg(String action) {
        String msg = L10N.getLocalString("msg.you_are_" + action + "_without_saving_txt", null);
        if (msg != null) {
            return msg;
        }
        return L10N.getLocalString("msg.you_are_" + action + "_txt", "You are " + action) + " " + L10N.getLocalString("msg.without_saving_txt", "without saving. Do you want to save?");
    }

    public void updateBugTree() {
        this.mainFrameTree.updateBugTree();
    }

    public void resetViewCache() {
        ((BugTreeModel)this.mainFrameTree.getTree().getModel()).clearViewCache();
    }

    public void updateTitle() {
        String newTitle;
        String oldTitle;
        Project project = this.getProject();
        String name = project.getProjectName();
        if ((name == null || name.trim().isEmpty()) && this.saveFile != null) {
            name = this.saveFile.getAbsolutePath();
        }
        if (name == null) {
            name = "";
        }
        if ((oldTitle = this.getTitle()).equals(newTitle = TITLE_START_TXT + (String)("".equals(name.trim()) ? "" : " - " + name))) {
            return;
        }
        this.setTitle(newTitle);
    }

    private boolean shouldDisplayIssueIgnoringPackagePrefixes(BugInstance b) {
        Project project = this.getProject();
        Filter suppressionFilter = project.getSuppressionFilter();
        if (null == this.getBugCollection() || suppressionFilter.match(b)) {
            return false;
        }
        return this.viewFilter.showIgnoringPackagePrefixes(b);
    }

    public void selectPackagePrefixByProject() {
        TreeSet<String> projects = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Multiset<String> count = new Multiset<String>();
        int total = 0;
        for (BugInstance b : this.getBugCollection().getCollection()) {
            if (!this.shouldDisplayIssueIgnoringPackagePrefixes(b)) continue;
            TreeSet<String> projectsForThisBug = this.projectPackagePrefixes.getProjects(b.getPrimaryClass().getClassName());
            projects.addAll(projectsForThisBug);
            count.addAll(projectsForThisBug);
            ++total;
        }
        if (projects.size() == 0) {
            JOptionPane.showMessageDialog(this, "No issues in current view");
            return;
        }
        ArrayList<ProjectSelector> selectors = new ArrayList<ProjectSelector>(projects.size() + 1);
        ProjectSelector everything = new ProjectSelector("all projects", "", total);
        selectors.add(everything);
        for (String projectName : projects) {
            ProjectPackagePrefixes.PrefixFilter filter = this.projectPackagePrefixes.getFilter(projectName);
            selectors.add(new ProjectSelector(projectName, filter.toString(), count.getCount(projectName)));
        }
        ProjectSelector choice = (ProjectSelector)JOptionPane.showInputDialog(null, "Choose a project to set appropriate package prefix(es)", "Select package prefixes by package", 3, null, selectors.toArray(), everything);
        if (choice == null) {
            return;
        }
        this.mainFrameTree.setFieldForPackagesToDisplayText(choice.filter);
        this.viewFilter.setPackagesToDisplay(choice.filter);
        this.resetViewCache();
    }

    private static String join(String s1, String s2) {
        if (s1 == null || s1.length() == 0) {
            return s2;
        }
        if (s2 == null || s2.length() == 0) {
            return s1;
        }
        return s1 + "; " + s2;
    }

    private void updateSummaryTab(BugLeafNode node) {
        BugInstance bug = node.getBug();
        SwingUtilities.invokeLater(() -> {
            this.summaryTopPanel.removeAll();
            this.summaryTopPanel.add(this.mainFrameComponentFactory.bugSummaryComponent(bug.getAbridgedMessage(), bug));
            for (BugAnnotation b : bug.getAnnotationsForMessage(true)) {
                this.summaryTopPanel.add(this.mainFrameComponentFactory.bugSummaryComponent(b, bug));
            }
            BugPattern bugPattern = bug.getBugPattern();
            String detailText = bugPattern.getDetailText() + "<br><p> <b>Bug kind and pattern: " + bugPattern.getAbbrev() + " - " + bugPattern.getType();
            String txt = bugPattern.getDetailHTML(detailText);
            this.summaryHtmlArea.setText(txt);
            this.summaryTopPanel.add(Box.createVerticalGlue());
            this.summaryTopPanel.revalidate();
            SwingUtilities.invokeLater(() -> this.summaryHtmlScrollPane.getVerticalScrollBar().setValue(this.summaryHtmlScrollPane.getVerticalScrollBar().getMinimum()));
        });
    }

    public void clearSummaryTab() {
        this.summaryHtmlArea.setText("");
        this.summaryTopPanel.removeAll();
        this.summaryTopPanel.revalidate();
    }

    public void searchSource(int type) {
        int targetLineNum = -1;
        String targetString = this.sourceSearchTextField.getText();
        switch (type) {
            case 0: {
                targetLineNum = this.displayer.find(targetString);
                break;
            }
            case 1: {
                targetLineNum = this.displayer.findNext(targetString);
                break;
            }
            case 2: {
                targetLineNum = this.displayer.findPrevious(targetString);
                break;
            }
        }
        if (targetLineNum != -1) {
            this.displayer.foundItem(targetLineNum);
        }
    }

    public void createProjectSettings() {
        ProjectSettings.newInstance();
    }

    public void addFileToRecent(File xmlFile) {
        this.mainFrameMenu.addFileToRecent(xmlFile);
    }

    public void setSaveType(SaveType saveType) {
        if (GUI2_DEBUG && this.saveType != saveType) {
            System.out.println("Changing save type from " + String.valueOf((Object)this.saveType) + " to " + String.valueOf((Object)saveType));
        }
        this.saveType = saveType;
    }

    public SaveType getSaveType() {
        return this.saveType;
    }

    public BugLeafNode getCurrentSelectedBugLeaf() {
        return this.mainFrameTree.getCurrentSelectedBugLeaf();
    }

    public BugAspects getCurrentSelectedBugAspects() {
        return this.currentSelectedBugAspects;
    }

    public NavigableTextPane getSourceCodeTextPane() {
        return this.sourceCodeTextPane;
    }

    public BugCollection getBugCollection() {
        return this.bugCollection;
    }

    public boolean isProjectChanged() {
        return this.projectChanged;
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public Project getCurrentProject() {
        return this.curProject;
    }

    public JMenuItem getSaveMenuItem() {
        return this.mainFrameMenu.getSaveMenuItem();
    }

    public void setSaveFile(File saveFile) {
        this.saveFile = saveFile;
    }

    public ExecutorService getBackgroundExecutor() {
        return this.backgroundExecutor;
    }

    public JMenuItem getReconfigMenuItem() {
        return this.mainFrameMenu.getReconfigMenuItem();
    }

    public SourceCodeDisplay getSourceCodeDisplayer() {
        return this.displayer;
    }

    public ProjectPackagePrefixes getProjectPackagePrefixes() {
        return this.projectPackagePrefixes;
    }

    public void enableRecentMenu(boolean enable) {
        this.mainFrameMenu.enableRecentMenu(enable);
    }

    public void setCurrentSelectedBugAspects(BugAspects currentSelectedBugAspects) {
        this.currentSelectedBugAspects = currentSelectedBugAspects;
    }

    public ViewFilter getViewFilter() {
        return this.viewFilter;
    }

    public Project getCurProject() {
        return this.curProject;
    }

    public MainFrameLoadSaveHelper getMainFrameLoadSaveHelper() {
        return this.mainFrameLoadSaveHelper;
    }

    public FindBugsLayoutManager getGuiLayout() {
        return this.guiLayout;
    }

    public MainFrameTree getMainFrameTree() {
        return this.mainFrameTree;
    }

    public boolean projectChanged() {
        return this.projectChanged;
    }

    public MainFrameMenu getMainFrameMenu() {
        return this.mainFrameMenu;
    }

    public JEditorPane getSummaryHtmlArea() {
        return this.summaryHtmlArea;
    }

    public JLabel getStatusBarLabel() {
        return this.statusBarLabel;
    }

    public JButton getFindNextButton() {
        return this.findNextButton;
    }

    public JScrollPane getSummaryHtmlScrollPane() {
        return this.summaryHtmlScrollPane;
    }

    public JButton getFindPreviousButton() {
        return this.findPreviousButton;
    }

    public JTextField getSourceSearchTextField() {
        return this.sourceSearchTextField;
    }

    public JButton getFindButton() {
        return this.findButton;
    }

    public JPanel getSummaryTopPanel() {
        return this.summaryTopPanel;
    }

    public void setSummaryTopPanel(JPanel summaryTopPanel) {
        this.summaryTopPanel = summaryTopPanel;
    }

    void waitForMainFrameInitialized() {
        this.mainFrameInitialized.countDown();
    }

    private class MyGuiCallback
    extends AbstractSwingGuiCallback {
        private MyGuiCallback() {
            super(MainFrame.this);
        }

        @Override
        public void setErrorMessage(String errorMsg) {
            MainFrame.this.errorMsg = errorMsg;
            SwingUtilities.invokeLater(() -> MainFrame.this.updateStatusBar());
        }
    }

    static enum BugCard {
        TREECARD,
        WAITCARD;

    }

    private static class ProjectSelector {
        final String projectName;
        final String filter;
        final int count;

        public ProjectSelector(String projectName, String filter, int count) {
            this.projectName = projectName;
            this.filter = filter;
            this.count = count;
        }

        public String toString() {
            return String.format("%s -- [%d issues]", this.projectName, this.count);
        }
    }
}

