/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.Map;
import org.apache.bcel.classfile.Code;

public class UnnecessaryEnvUsage
extends OpcodeStackDetector {
    private static final Map<String, String> envvarPropertyMap = Map.ofEntries(Map.entry("JAVA_HOME", "java.home"), Map.entry("JAVA_VERSION", "java.version"), Map.entry("TEMP", "java.io.tmpdir"), Map.entry("TMP", "java.io.tmpdir"), Map.entry("PROCESSOR_ARCHITECTURE", "os.arch"), Map.entry("OS", "os.name"), Map.entry("USER", "user.name"), Map.entry("USERNAME", "user.name"), Map.entry("HOME", "user.home"), Map.entry("HOMEPATH", "user.home"), Map.entry("CD", "user.dir"), Map.entry("PWD", "user.dir"));
    private final BugAccumulator bugAccumulator;

    public UnnecessaryEnvUsage(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(Code obj) {
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    private void reportBugIfParamIsProblematic() {
        String constant;
        OpcodeStack.Item top = this.stack.getStackItem(0);
        if (top.getConstant() instanceof String && envvarPropertyMap.containsKey(constant = (String)top.getConstant())) {
            BugInstance pendingBug = new BugInstance(this, "ENV_USE_PROPERTY_INSTEAD_OF_ENV", 2).addClassAndMethod(this).addString(constant).addString(envvarPropertyMap.get(constant));
            this.bugAccumulator.accumulateBug(pendingBug, SourceLineAnnotation.fromVisitedInstruction(this, this.getPC()));
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 184 || seen == 185) {
            XMethod rvo;
            XMethod xMethod = this.getXMethodOperand();
            if (xMethod == null) {
                return;
            }
            if ("java.lang.System".equals(xMethod.getClassName()) && "getenv".equals(xMethod.getName()) && "(Ljava/lang/String;)Ljava/lang/String;".equals(xMethod.getSignature())) {
                this.reportBugIfParamIsProblematic();
            } else if ("java.util.Map".equals(xMethod.getClassName()) && "get".equals(xMethod.getName()) && "(Ljava/lang/Object;)Ljava/lang/Object;".equals(xMethod.getSignature()) && this.stack.getStackDepth() >= 2 && (rvo = this.stack.getStackItem(1).getReturnValueOf()) != null && "java.lang.System".equals(rvo.getClassName()) && "getenv".equals(rvo.getName()) && "()Ljava/util/Map;".equals(rvo.getSignature())) {
                this.reportBugIfParamIsProblematic();
            }
        }
    }
}

