/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.Arrays;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class PermissionsSuper
extends OpcodeStackDetector {
    private boolean checkClass = false;
    private boolean checkMethod = false;
    private final BugAccumulator bugAccumulator;

    public PermissionsSuper(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(JavaClass obj) {
        this.checkClass = false;
        try {
            this.checkClass = obj.instanceOf(Repository.lookupClass((String)"java.security.SecureClassLoader"));
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        super.visit(obj);
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void visit(Method met) {
        this.checkMethod = this.checkClass && "(Ljava/security/CodeSource;)Ljava/security/PermissionCollection;".equals(met.getSignature());
        super.visit(met);
    }

    @Override
    public void visit(Code obj) {
        if (this.checkMethod) {
            super.visit(obj);
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 176) {
            XMethod origin = this.stack.getStackItem(0).getReturnValueOf();
            if (origin != null) {
                try {
                    if (Arrays.stream(this.getThisClass().getSuperClasses()).anyMatch(cls -> cls.getClassName().equals(origin.getClassName())) && this.getMethod().getName().equals(origin.getName()) && this.getMethod().getSignature().equals(origin.getSignature())) {
                        return;
                    }
                }
                catch (ClassNotFoundException e) {
                    AnalysisContext.reportMissingClass(e);
                }
            }
            this.bugAccumulator.accumulateBug(new BugInstance(this, "PERM_SUPER_NOT_CALLED_IN_GETPERMISSIONS", 2).addClassAndMethod(this), this);
        }
    }
}

