/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;

public class FindVulnerableSecurityCheckMethods
extends OpcodeStackDetector {
    private final BugReporter bugReporter;
    private static final Set<String> badMethodNames = Set.of("checkAccept", "checkAccess", "checkAwtEventQueueAccess", "checkConnect", "checkCreateClassLoader", "checkDelete", "checkExec", "checkExit", "checkLink", "checkListen", "checkMemberAccess", "checkMulticast", "checkPackageAccess", "checkPackageDefinition", "checkPermission", "checkPrintJobAccess", "checkPropertiesAccess", "checkRead", "checkSecurityAccess", "checkSetFactory", "checkSystemClipboardAccess", "checkTopLevelWindow", "checkWrite", "classDepth", "classLoaderDepth", "currentClassLoader", "currentLoadedClass", "getInCheck", "inClass", "inClassLoader");

    public FindVulnerableSecurityCheckMethods(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        JavaClass ctx = classContext.getJavaClass();
        if (ctx.isFinal()) {
            return;
        }
        super.visitClassContext(classContext);
    }

    private boolean isMethodCall(int seen) {
        return seen == 184 || seen == 182 || seen == 185 || seen == 183;
    }

    @Override
    public void sawOpcode(int seen) {
        if (this.isMethodCall(seen)) {
            XMethod method = this.getXMethod();
            if (method == null) {
                return;
            }
            if (!method.isFinal() && !method.isPrivate()) {
                XMethod calledMethod = this.getXMethodOperand();
                if (calledMethod == null) {
                    return;
                }
                if ("java.lang.SecurityManager".equals(calledMethod.getClassName()) && badMethodNames.contains(calledMethod.getName())) {
                    this.bugReporter.reportBug(new BugInstance(this, "VSC_VULNERABLE_SECURITY_CHECK_METHODS", 2).addClass(this.getClassContext().getJavaClass()).addMethod(method).addMethod(calledMethod).addSourceLine(SourceLineAnnotation.fromVisitedInstruction(this, this.getPC())));
                }
            }
        }
    }
}

