/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.FieldOrMethodName;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.bcel.classfile.JavaClass;

public class FindInstanceLockOnSharedStaticData
extends OpcodeStackDetector {
    private static final String JAVA_LANG_CLASS = "java.lang.Class";
    private final BugAccumulator bugAccumulator;
    private boolean isInsideSynchronizedBlock;
    private Optional<XField> maybeLockObject;
    private boolean isLockObjectInstanceOfJavaLangClass;

    public FindInstanceLockOnSharedStaticData(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
        this.isInsideSynchronizedBlock = false;
        this.maybeLockObject = Optional.empty();
        this.isLockObjectInstanceOfJavaLangClass = false;
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 194) {
            this.isInsideSynchronizedBlock = true;
            OpcodeStack.Item lockObject = this.stack.getStackItem(0);
            this.maybeLockObject = Optional.ofNullable(lockObject.getXField());
            if (!this.maybeLockObject.isPresent()) {
                try {
                    Optional<JavaClass> javaClassOfLockObject = Optional.ofNullable(lockObject.getJavaClass());
                    this.isLockObjectInstanceOfJavaLangClass = javaClassOfLockObject.map(javaClass -> javaClass.getClassName().equals(JAVA_LANG_CLASS)).orElse(false);
                }
                catch (ClassNotFoundException javaClassOfLockObject) {
                    // empty catch block
                }
            }
            return;
        }
        if (seen == 195) {
            this.isInsideSynchronizedBlock = false;
            this.maybeLockObject = Optional.empty();
            return;
        }
        if (seen == 179) {
            boolean isLockObjectAppropriate;
            XMethod modificationMethod = this.getXMethod();
            Optional<XField> fieldToModify = Optional.ofNullable(this.getXFieldOperand());
            boolean unsecuredModificationByMethod = fieldToModify.isPresent() && modificationMethod.isSynchronized() && !modificationMethod.isStatic();
            boolean bl = isLockObjectAppropriate = this.maybeLockObject.map(FieldOrMethodName::isStatic).orElse(false) != false || this.isLockObjectInstanceOfJavaLangClass;
            if (!(!unsecuredModificationByMethod || this.isInsideSynchronizedBlock && isLockObjectAppropriate)) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "SSD_DO_NOT_USE_INSTANCE_LOCK_ON_SHARED_STATIC_DATA", 2).addClassAndMethod(this).addString(fieldToModify.get().getName()).addString("synchronized method"), this);
                return;
            }
            if (fieldToModify.isPresent() && this.isInsideSynchronizedBlock && !isLockObjectAppropriate) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "SSD_DO_NOT_USE_INSTANCE_LOCK_ON_SHARED_STATIC_DATA", 2).addClassAndMethod(this).addString(fieldToModify.get().getName()).addString("synchronization lock"), this);
            }
        }
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void visit(JavaClass obj) {
        boolean classIsInteresting = Stream.of(obj.getFields()).anyMatch(field -> field.isStatic() && !field.isFinal());
        if (classIsInteresting) {
            this.isInsideSynchronizedBlock = false;
            this.maybeLockObject = Optional.empty();
            this.isLockObjectInstanceOfJavaLangClass = false;
            super.visit(obj);
        }
    }
}

