/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.ICodeBaseIterator;
import edu.umd.cs.findbugs.classfile.ICodeBaseLocator;
import edu.umd.cs.findbugs.classfile.InvalidClassFileFormatException;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBase;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBaseEntry;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class JrtfsCodeBase
extends AbstractScannableCodeBase {
    private static final int PRIME = 31;
    private FileSystem fs;
    private final String fileName;
    private Path root;
    private Map<String, Object> packageToModuleMap;

    public JrtfsCodeBase(ICodeBaseLocator codeBaseLocator, @Nonnull String fileName) {
        super(codeBaseLocator);
        this.fileName = fileName;
        try {
            URL url = Path.of(fileName, new String[0]).toUri().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{url});
            this.fs = FileSystems.newFileSystem(URI.create("jrt:/"), Collections.emptyMap(), (ClassLoader)loader);
            this.root = this.fs.getPath("modules", new String[0]);
            this.packageToModuleMap = this.createPackageToModuleMap(this.fs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> createPackageToModuleMap(FileSystem fs) throws IOException {
        LinkedHashMap<String, Object> packageToModule = new LinkedHashMap<String, Object>();
        Path path = fs.getPath("packages", new String[0]);
        try (Stream<Path> packList = Files.list(path);){
            packList.forEach(p -> {
                try (Stream<Path> pList = Files.list(p);){
                    Iterator modIter = pList.iterator();
                    while (modIter.hasNext()) {
                        Path module = (Path)modIter.next();
                        String packageKey = ClassName.toSlashedClassName(JrtfsCodeBase.fileName(p));
                        String modulePath = JrtfsCodeBase.fileName(module);
                        if (!modIter.hasNext() && !packageToModule.containsKey(packageKey)) {
                            packageToModule.put(packageKey, modulePath);
                            continue;
                        }
                        LinkedHashSet<String> modules = (LinkedHashSet<String>)packageToModule.get(packageKey);
                        if (modules == null) {
                            modules = new LinkedHashSet<String>();
                            packageToModule.put(packageKey, modules);
                        }
                        modules.add(modulePath);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        return packageToModule;
    }

    @Override
    @CheckForNull
    public ICodeBaseEntry lookupResource(String resourceName) {
        String packageName = JrtfsCodeBase.getPackage(resourceName = this.translateResourceName(resourceName));
        Object moduleNameOrSet = this.packageToModuleMap.get(packageName);
        if (moduleNameOrSet == null) {
            return null;
        }
        if (moduleNameOrSet instanceof String) {
            return this.createEntry(resourceName, (String)moduleNameOrSet);
        }
        Set modules = (Set)moduleNameOrSet;
        for (String moduleName : modules) {
            ICodeBaseEntry entry = this.createEntry(resourceName, moduleName);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    @CheckForNull
    private ICodeBaseEntry createEntry(String resourceName, String moduleName) {
        Path resolved = this.root.resolve(moduleName + "/" + resourceName);
        if (Files.exists(resolved, new LinkOption[0])) {
            return new JrtfsCodebaseEntry(resolved, this.root, this);
        }
        return null;
    }

    private static String getPackage(String resourceName) {
        int lastSlash = resourceName.lastIndexOf(47);
        if (lastSlash > 0) {
            return resourceName.substring(0, lastSlash);
        }
        return resourceName;
    }

    @Override
    public String getPathName() {
        return this.fileName;
    }

    public int hashCode() {
        return 31 + this.fileName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JrtfsCodeBase)) {
            return false;
        }
        return this.fileName.equals(((JrtfsCodeBase)obj).fileName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JrtfsCodeBase [");
        if (this.fileName != null) {
            builder.append("file=");
            builder.append(this.fileName);
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void close() {
        if (this.fs != null) {
            try {
                this.fs.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ICodeBaseIterator iterator() throws InterruptedException {
        return new JrtfsCodeBaseIterator();
    }

    @Nonnull
    static String fileName(Path p) {
        Path name = p.getFileName();
        return name != null ? name.toString() : "";
    }

    static boolean isClassFile(Path p) {
        return p.endsWith(".class") && !p.endsWith("module-info.class") && Files.isRegularFile(p, new LinkOption[0]);
    }

    public static class JrtfsCodebaseEntry
    extends AbstractScannableCodeBaseEntry {
        private final Path path;
        private final Path root;
        private final JrtfsCodeBase codebase;

        public JrtfsCodebaseEntry(Path next, Path root, JrtfsCodeBase codebase) {
            this.path = next;
            this.root = root;
            this.codebase = codebase;
        }

        @Override
        public int getNumBytes() {
            try {
                return (int)Files.size(this.path);
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }

        @Override
        public InputStream openResource() throws IOException {
            return new BufferedInputStream(Files.newInputStream(this.path, StandardOpenOption.READ));
        }

        @Override
        public JrtfsCodeBase getCodeBase() {
            return this.codebase;
        }

        @Override
        public ClassDescriptor getClassDescriptor() throws ResourceNotFoundException, InvalidClassFileFormatException {
            return DescriptorFactory.createClassDescriptorFromResourceName(this.getResourceName());
        }

        @Override
        public String getRealResourceName() {
            return this.root.relativize(this.path).toString();
        }

        public int hashCode() {
            int result = 31 + this.codebase.hashCode();
            result = 31 * result + this.path.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof JrtfsCodebaseEntry)) {
                return false;
            }
            JrtfsCodebaseEntry other = (JrtfsCodebaseEntry)obj;
            if (!Objects.equals(this.codebase, other.codebase)) {
                return false;
            }
            return Objects.equals(this.path, other.path);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("JrtfsCodebaseEntry [");
            if (this.path != null) {
                builder.append("path=");
                builder.append(this.path);
                builder.append(", ");
            }
            if (this.codebase != null) {
                builder.append("codebase=");
                builder.append(this.codebase);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    public class JrtfsCodeBaseIterator
    implements ICodeBaseIterator {
        private Iterator<Path> iterator;

        public JrtfsCodeBaseIterator() {
            try {
                this.iterator = Files.walk(JrtfsCodeBase.this.root, new FileVisitOption[0]).filter(p -> JrtfsCodeBase.isClassFile(p)).iterator();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean hasNext() throws InterruptedException {
            return this.iterator.hasNext();
        }

        @Override
        public ICodeBaseEntry next() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Path next = this.iterator.next();
            return new JrtfsCodebaseEntry(next, JrtfsCodeBase.this.root, JrtfsCodeBase.this);
        }
    }
}

