/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.bcp.ByteCodePattern;
import edu.umd.cs.findbugs.ba.bcp.ByteCodePatternMatch;
import edu.umd.cs.findbugs.ba.bcp.PatternElementMatch;
import edu.umd.cs.findbugs.ba.bcp.PatternMatcher;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.MethodGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ByteCodePatternDetector
implements Detector {
    private static final Logger LOG = LoggerFactory.getLogger(ByteCodePatternDetector.class);
    private static final String METHOD = SystemProperties.getProperty("bcpd.method");

    protected abstract BugReporter getBugReporter();

    @Override
    public void visitClassContext(ClassContext classContext) {
        try {
            Method[] methodList;
            ByteCodePattern pattern = this.getPattern();
            JavaClass jclass = classContext.getJavaClass();
            for (Method method : methodList = jclass.getMethods()) {
                MethodGen methodGen;
                if (method.isAbstract() || method.isNative() || METHOD != null && !method.getName().equals(METHOD)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Method {}.{}", (Object)jclass.getClassName(), (Object)method.getName());
                }
                if (!this.prescreen(method, classContext) || (methodGen = classContext.getMethodGen(method)) == null) continue;
                PatternMatcher matcher = new PatternMatcher(pattern, classContext, method);
                matcher.execute();
                Iterator<ByteCodePatternMatch> j = matcher.byteCodePatternMatchIterator();
                while (j.hasNext()) {
                    ByteCodePatternMatch match = j.next();
                    if (LOG.isDebugEnabled()) {
                        Iterator<PatternElementMatch> pemIter = match.patternElementMatchIterator();
                        String pem = ByteCodePatternDetector.createStream(pemIter).map(Object::toString).collect(Collectors.joining("\t"));
                        LOG.debug("Pattern match: {}", (Object)pem);
                    }
                    this.reportMatch(classContext, method, match);
                }
            }
        }
        catch (CFGBuilderException | DataflowAnalysisException e) {
            this.getBugReporter().logError(this.getDetectorName() + " caught exception", e);
        }
    }

    @NonNull
    private static <T> Stream<T> createStream(@NonNull Iterator<T> iter) {
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iter, 16);
        return StreamSupport.stream(spliterator, false);
    }

    private String getDetectorName() {
        String className = this.getClass().getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot >= 0) {
            className = className.substring(lastDot + 1);
        }
        return className;
    }

    @Override
    public void report() {
    }

    public abstract ByteCodePattern getPattern();

    public abstract boolean prescreen(Method var1, ClassContext var2);

    public abstract void reportMatch(ClassContext var1, Method var2, ByteCodePatternMatch var3) throws CFGBuilderException, DataflowAnalysisException;
}

