/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationslib.org.owasp.encoder;

import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import se.bjurr.violations.violationslib.org.owasp.encoder.Encoder;
import se.bjurr.violations.violationslib.org.owasp.encoder.Encoders;
import se.bjurr.violations.violationslib.org.owasp.encoder.UnsupportedContextException;

public class EncodedWriter
extends Writer {
    static final int BUFFER_SIZE = 1024;
    static final int LEFT_OVER_BUFFER = 16;
    private Writer _out;
    private Encoder _encoder;
    private CharBuffer _buffer = CharBuffer.allocate(1024);
    private boolean _hasLeftOver;
    private CharBuffer _leftOverBuffer;

    public EncodedWriter(Writer out, Encoder encoder) {
        super((Object)out);
        if (encoder == null) {
            throw new NullPointerException("encoder must not be null");
        }
        this._out = out;
        this._encoder = encoder;
    }

    public EncodedWriter(Writer out, String contextName) throws UnsupportedContextException {
        this(out, Encoders.forName(contextName));
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            CharBuffer input = CharBuffer.wrap(cbuf);
            input.limit(off + len).position(off);
            this.flushLeftOver(input);
            while (true) {
                CoderResult cr;
                if ((cr = this._encoder.encode(input, this._buffer, false)).isUnderflow()) {
                    if (input.hasRemaining()) {
                        if (this._leftOverBuffer == null) {
                            this._leftOverBuffer = CharBuffer.allocate(16);
                        }
                        this._leftOverBuffer.put(input);
                        this._hasLeftOver = true;
                    }
                    return;
                }
                if (!cr.isOverflow()) continue;
                this.flushBufferToWriter();
            }
        }
    }

    private void flushBufferToWriter() throws IOException {
        this._out.write(this._buffer.array(), 0, this._buffer.position());
        this._buffer.clear();
    }

    private void flushLeftOver(CharBuffer input) throws IOException {
        if (!this._hasLeftOver) {
            return;
        }
        while (true) {
            if (input != null && input.hasRemaining()) {
                this._leftOverBuffer.put(input.get());
            }
            this._leftOverBuffer.flip();
            CoderResult cr = this._encoder.encode(this._leftOverBuffer, this._buffer, input == null);
            if (cr.isUnderflow()) {
                if (!this._leftOverBuffer.hasRemaining()) break;
                this._leftOverBuffer.compact();
            }
            if (!cr.isOverflow()) continue;
            this.flushBufferToWriter();
        }
        this._hasLeftOver = false;
        this._leftOverBuffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBufferToWriter();
            this._out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushLeftOver(null);
            this.flushBufferToWriter();
            this._out.close();
        }
    }
}

