/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.Optional;
import se.bjurr.violations.lib.model.generated.sarif.ReportingDescriptor;
import se.bjurr.violations.lib.model.generated.sarif.ReportingDescriptorReference;
import se.bjurr.violations.lib.model.generated.sarif.Result;
import se.bjurr.violations.lib.model.generated.sarif.Run;
import se.bjurr.violations.lib.model.generated.sarif.ToolComponent;
import se.bjurr.violations.lib.model.generated.sarif.ToolComponentReference;

public class SarifParserReportingDescriptorFinder {
    static String findRuleId(Result result, ReportingDescriptorReference ref) {
        String ruleId = result.getRuleId();
        if (ruleId == null && ref != null) {
            return ref.getId();
        }
        return ruleId;
    }

    static Optional<ReportingDescriptor> findReportingDescriptor(Run run, Result result, DescriptorElementOf lookIn) {
        ReportingDescriptorReference ref = result.getRule();
        Integer ruleIndex = SarifParserReportingDescriptorFinder.findRuleIndex(result, ref);
        String ruleId = SarifParserReportingDescriptorFinder.findRuleId(result, ref);
        return SarifParserReportingDescriptorFinder.findReportingDescriptor(run, lookIn, ref, ruleIndex, ruleId);
    }

    static Optional<ReportingDescriptor> findReportingDescriptor(Run run, DescriptorElementOf lookIn, ReportingDescriptorReference ref, String ruleId) {
        Integer ruleIndex = SarifParserReportingDescriptorFinder.getRuleIndex(ref);
        return SarifParserReportingDescriptorFinder.findReportingDescriptor(run, lookIn, ref, ruleIndex, ruleId);
    }

    static ToolComponent findToolComponent(Run run, ReportingDescriptorReference ref) {
        if (run.getTool() == null) {
            return null;
        }
        if (ref == null) {
            return run.getTool().getDriver();
        }
        ToolComponentReference toolRef = ref.getToolComponent();
        if (toolRef == null) {
            return run.getTool().getDriver();
        }
        if (toolRef.getGuid() != null) {
            return SarifParserReportingDescriptorFinder.getToolComponentByGui(run, toolRef.getGuid());
        }
        if (toolRef.getIndex() != null) {
            return SarifParserReportingDescriptorFinder.getToolComponentByIndex(run, toolRef.getIndex());
        }
        return run.getTool().getDriver();
    }

    private static Optional<ReportingDescriptor> findReportingDescriptor(Run run, DescriptorElementOf lookIn, ReportingDescriptorReference ref, Integer ruleIndex, String ruleId) {
        ToolComponent tool = SarifParserReportingDescriptorFinder.findToolComponent(run, ref);
        if (tool == null) {
            return Optional.empty();
        }
        if (ruleIndex != null) {
            return Optional.of(SarifParserReportingDescriptorFinder.getReportingDescriptorByIndex(tool, ruleIndex, lookIn));
        }
        if (ref != null && ref.getGuid() != null) {
            return SarifParserReportingDescriptorFinder.findReportingDescriptorByGui(tool, ref.getGuid(), lookIn);
        }
        if (ruleId != null) {
            return SarifParserReportingDescriptorFinder.findReportingDescriptorByRuleId(tool, ruleId, lookIn);
        }
        return Optional.empty();
    }

    private static Integer getRuleIndex(ReportingDescriptorReference ref) {
        Integer ruleIndex = null;
        if (ref != null) {
            ruleIndex = ref.getIndex();
        }
        if (ruleIndex == null || ruleIndex == -1) {
            return null;
        }
        return ruleIndex;
    }

    private static Integer findRuleIndex(Result result, ReportingDescriptorReference ref) {
        Integer ruleIndex = result.getRuleIndex();
        if (ruleIndex == -1 && ref != null) {
            ruleIndex = ref.getIndex();
        }
        if (ruleIndex == -1) {
            return null;
        }
        return ruleIndex;
    }

    private static ReportingDescriptor getReportingDescriptorByIndex(ToolComponent tool, Integer index, DescriptorElementOf lookIn) {
        if (lookIn == DescriptorElementOf.RULES) {
            return new ArrayList<ReportingDescriptor>(tool.getRules()).get(index);
        }
        if (lookIn == DescriptorElementOf.NOTIFICATIONS) {
            return new ArrayList<ReportingDescriptor>(tool.getNotifications()).get(index);
        }
        throw new IllegalStateException(String.valueOf((Object)lookIn) + " cannot find ReportingDescriptor");
    }

    private static Optional<ReportingDescriptor> findReportingDescriptorByGui(ToolComponent tool, String guid, DescriptorElementOf lookIn) {
        if (lookIn == DescriptorElementOf.RULES) {
            return tool.getRules().stream().filter(it -> it.getGuid() != null && it.getGuid().equals(guid)).findFirst();
        }
        if (lookIn == DescriptorElementOf.NOTIFICATIONS) {
            return tool.getNotifications().stream().filter(it -> it.getGuid() != null && it.getGuid().equals(guid)).findFirst();
        }
        return Optional.empty();
    }

    private static Optional<ReportingDescriptor> findReportingDescriptorByRuleId(ToolComponent tool, String ruleId, DescriptorElementOf lookIn) {
        if (lookIn == DescriptorElementOf.RULES) {
            return tool.getRules().stream().filter(it -> it.getId() != null && it.getId().equals(ruleId)).findFirst();
        }
        if (lookIn == DescriptorElementOf.NOTIFICATIONS) {
            return tool.getNotifications().stream().filter(it -> it.getId() != null && it.getId().equals(ruleId)).findFirst();
        }
        throw new IllegalStateException(String.valueOf((Object)lookIn) + " cannot find ReportingDescriptor");
    }

    private static ToolComponent getToolComponentByIndex(Run run, Integer index) {
        return new ArrayList<ToolComponent>(run.getTool().getExtensions()).get(index);
    }

    private static ToolComponent getToolComponentByGui(Run run, String guid) {
        return run.getTool().getExtensions().stream().filter(it -> it.getGuid() != null && it.getGuid().equals(guid)).findFirst().get();
    }

    static enum DescriptorElementOf {
        RULES,
        NOTIFICATIONS;

    }
}

